/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.osgb36;

import org.apache.commons.lang3.StringUtils;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.osgb36.OsGb36ConverterEngine;
import uk.m0nom.adifproc.osgb36.OsGb36ConverterResult;

@Service
public class OsGb36Converter {
    private final OsGb36ConverterEngine engine = new OsGb36ConverterEngine();

    public OsGb36ConverterResult convertOsGb36ToCoords(String osGb36Location) {
        OsGb36ConverterResult result = new OsGb36ConverterResult();
        result.setOsGb36(osGb36Location);
        this.engine.deletestringbuffers();
        this.engine.bngoldcoordinatesstringbuffer.append(osGb36Location);
        this.engine.bngoldheightstringbuffer.append("0.0");
        this.engine.convertoldbngtonewbng();
        if (this.engine.stopcalculating) {
            this.engine.showerrormessage("Calculation stopped!");
        } else {
            this.engine.convertnewbngtolonglatosgb36();
            this.engine.convertlonglatdecosgb36tolonglatosgb36();
            this.engine.convertlonglatosgb36cartesianosgb36();
            this.engine.helmerttransformation(false);
            this.engine.convertcartesianwgs84longlatwgs84();
            this.engine.convertlonglatdecwgs84tolonglatwgs84();
            this.engine.convertlatlongwgs84todbx();
            this.engine.calcconvandscale();
            this.engine.showresults();
        }
        result.setError(this.engine.messagestextareastringbuffer.toString().replace('\n', ' '));
        result.setSuccess(StringUtils.isEmpty((CharSequence)result.getError()));
        result.setCoords(new GlobalCoordinates(this.engine.latitudedecosgb36, this.engine.longitudedecosgb36));
        return result;
    }

    public OsGb36ConverterResult convertCoordsToOsGb36(GlobalCoordinates coords) {
        OsGb36ConverterResult result = new OsGb36ConverterResult();
        result.setCoords(coords);
        this.engine.deletestringbuffers();
        this.engine.latitudedecosgb36stringbuffer.append(coords.getLatitude());
        this.engine.longitudedecosgb36stringbuffer.append(coords.getLongitude());
        this.engine.bngoldheightstringbuffer.append("0.0");
        this.engine.convertlonglatosgb36tonewbng();
        if (this.engine.stopcalculating) {
            this.engine.showerrormessage("Calculation stopped!");
        } else {
            this.engine.convertlonglatdecosgb36tolonglatosgb36();
            this.engine.convertlonglatosgb36cartesianosgb36();
            this.engine.helmerttransformation(false);
            this.engine.convertcartesianwgs84longlatwgs84();
            this.engine.convertlonglatdecwgs84tolonglatwgs84();
            this.engine.convertlatlongwgs84todbx();
            this.engine.calcconvandscale();
            this.engine.convertnewbngtooldbng();
            this.engine.showresults();
        }
        result.setError(this.engine.messagestextareastringbuffer.toString().replace('\n', ' '));
        result.setSuccess(StringUtils.isEmpty((CharSequence)result.getError()));
        result.setOsGb36(this.engine.bngoldcoordinatesstringbuffer.toString());
        return result;
    }

    public OsGb36ConverterResult convertOsGb36EastingNorthingToCoords(String easting, String northing) {
        OsGb36ConverterResult result = new OsGb36ConverterResult();
        result.setOsGb36Easting(Double.parseDouble(easting));
        result.setOsGb36Northing(Double.parseDouble(northing));
        this.engine.deletestringbuffers();
        this.engine.bngeastingscoordinatesstringbuffer.append(easting);
        this.engine.bngnorthingscoordinatesstringbuffer.append(northing);
        this.engine.bngoldheightstringbuffer.append("0.0");
        this.engine.convertnewbngtolonglatosgb36();
        if (this.engine.stopcalculating) {
            this.engine.showerrormessage("Calculation stopped!");
        } else {
            this.engine.convertlonglatdecosgb36tolonglatosgb36();
            this.engine.convertlonglatosgb36cartesianosgb36();
            this.engine.helmerttransformation(false);
            this.engine.convertcartesianwgs84longlatwgs84();
            this.engine.convertlonglatdecwgs84tolonglatwgs84();
            this.engine.convertlatlongwgs84todbx();
            this.engine.calcconvandscale();
            this.engine.showresults();
        }
        result.setError(this.engine.messagestextareastringbuffer.toString().replace('\n', ' '));
        result.setSuccess(StringUtils.isEmpty((CharSequence)result.getError()));
        result.setCoords(new GlobalCoordinates(this.engine.latitudedecosgb36, this.engine.longitudedecosgb36));
        return result;
    }

    public OsGb36ConverterResult convertCoordsToOsGb36EastingNorthing(GlobalCoordinates coords) {
        OsGb36ConverterResult result = new OsGb36ConverterResult();
        result.setCoords(coords);
        this.engine.deletestringbuffers();
        this.engine.latitudedecosgb36stringbuffer.append(coords.getLatitude());
        this.engine.longitudedecosgb36stringbuffer.append(coords.getLongitude());
        this.engine.bngoldheightstringbuffer.append("0.0");
        this.engine.convertlonglatosgb36tonewbng();
        if (this.engine.stopcalculating) {
            this.engine.showerrormessage("Calculation stopped!");
        } else {
            this.engine.convertlonglatdecosgb36tolonglatosgb36();
            this.engine.convertlonglatosgb36cartesianosgb36();
            this.engine.helmerttransformation(false);
            this.engine.convertcartesianwgs84longlatwgs84();
            this.engine.convertlonglatdecwgs84tolonglatwgs84();
            this.engine.convertlatlongwgs84todbx();
            this.engine.calcconvandscale();
            this.engine.convertnewbngtooldbng();
            this.engine.showresults();
        }
        result.setError(this.engine.messagestextareastringbuffer.toString().replace('\n', ' '));
        result.setSuccess(StringUtils.isEmpty((CharSequence)result.getError()));
        result.setOsGb36Easting(Double.parseDouble(this.engine.bngeastingscoordinatesstringbuffer.toString()));
        result.setOsGb36Northing(Double.parseDouble(this.engine.bngnorthingscoordinatesstringbuffer.toString()));
        return result;
    }
}

