/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.qrz;

import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;
import uk.m0nom.adifproc.qrz.QrzCallsign;
import uk.m0nom.adifproc.qrz.QrzService;
import uk.m0nom.adifproc.qrz.QrzXmlService;

@Service
public class CachingQrzXmlService
implements QrzService {
    private final Map<String, QrzCallsign> cache = new HashMap<String, QrzCallsign>();
    private final QrzXmlService service;

    public CachingQrzXmlService(QrzXmlService service) {
        this.service = service;
    }

    @Override
    public void setCredentials(String username, String password) {
        this.service.setCredentials(username, password);
    }

    @Override
    public QrzCallsign getCallsignData(String callsign) {
        QrzCallsign callsignData = this.cache.get(callsign);
        if (callsignData == null) {
            callsignData = this.service.getCallsignData(callsign);
            if (callsign != null) {
                this.cache.put(callsign, callsignData);
            }
        }
        return callsignData;
    }

    @Override
    public boolean refreshSessionKey() {
        return this.service.refreshSessionKey();
    }

    @Override
    public boolean hasCredentials() {
        return this.service.hasCredentials();
    }
}

