/*
 * Decompiled with CFR 0.152.
 */
package uk.m0nom.adifproc.satellite;

import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import uk.m0nom.adifproc.satellite.ApSatellite;

public class ApSatellites {
    private final Map<String, ApSatellite> satelliteMap = new HashMap<String, ApSatellite>();
    private final Map<String, String> satelliteDesignatorToNameMap = new HashMap<String, String>();
    private final Set<LocalDate> datesLoaded = new TreeSet<LocalDate>();

    public void addOrReplace(ApSatellite satellite, LocalDate date) {
        String name = satellite.getName();
        if (this.satelliteMap.get(name) != null) {
            this.satelliteMap.remove(name);
            this.satelliteDesignatorToNameMap.remove(satellite.getDesignator());
        }
        this.satelliteMap.put(name, satellite);
        this.satelliteDesignatorToNameMap.put(satellite.getDesignator(), satellite.getName());
        if (date != null) {
            this.datesLoaded.add(date);
        }
    }

    public boolean hasDataFor(LocalDate date) {
        return date == null || this.datesLoaded.contains(date);
    }

    public ApSatellite get(String id) {
        String name;
        ApSatellite satellite = this.satelliteMap.get(id);
        if (satellite == null && (name = this.satelliteDesignatorToNameMap.get(id)) != null) {
            satellite = this.satelliteMap.get(name);
        }
        return satellite;
    }

    public Collection<String> getSatelliteNames() {
        return this.satelliteMap.keySet();
    }

    public int getSatelliteCount() {
        return this.satelliteMap.size();
    }
}

