/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.azure;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Tag;
import us.abstracta.jmeter.javadsl.azure.api.AppComponents;
import us.abstracta.jmeter.javadsl.azure.api.FileInfo;
import us.abstracta.jmeter.javadsl.azure.api.LoadTest;
import us.abstracta.jmeter.javadsl.azure.api.LoadTestResource;
import us.abstracta.jmeter.javadsl.azure.api.Location;
import us.abstracta.jmeter.javadsl.azure.api.ResourceGroup;
import us.abstracta.jmeter.javadsl.azure.api.ResponseList;
import us.abstracta.jmeter.javadsl.azure.api.Subscription;
import us.abstracta.jmeter.javadsl.azure.api.TestRun;
import us.abstracta.jmeter.javadsl.azure.api.Token;
import us.abstracta.jmeter.javadsl.engines.BaseRemoteEngineApiClient;
import us.abstracta.jmeter.javadsl.util.TestResource;

public class AzureClient
extends BaseRemoteEngineApiClient {
    private static final Logger LOG = LoggerFactory.getLogger(AzureClient.class);
    private static final String USER_AGENT = AzureClient.getUserAgent();
    private final String tenantId;
    private final String clientId;
    private final String clientSecret;
    private final LoginApi loginApi;
    private final ManagementApi managementApi;
    private String managementToken;
    private String loadTestToken;
    private LoadTestApi loadTestApi;
    private String dataPlaneUrl;

    public AzureClient(String tenantId, String clientId, String clientSecret) {
        super(LOG);
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.loginApi = (LoginApi)this.buildApiFor(String.format("https://login.microsoftonline.com/%s/oauth2/v2.0/", tenantId), LoginApi.class);
        this.managementApi = (ManagementApi)this.buildApiFor("https://management.azure.com/", ManagementApi.class);
    }

    private static String getUserAgent() {
        try {
            String userAgent = System.getProperty("us.abstracta.jmeterdsl.userAgent");
            if (userAgent != null) {
                return userAgent;
            }
            return "jmeter-java-dsl/" + new TestResource("us/abstracta/jmeter/javadsl/version.txt").rawContents();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void configureHttpClient(OkHttpClient.Builder builder) {
        builder.addInterceptor(this::addAgentHeader);
        super.configureHttpClient(builder);
    }

    private Response addAgentHeader(Interceptor.Chain chain) throws IOException {
        Request request = chain.request().newBuilder().header("User-Agent", USER_AGENT).build();
        return chain.proceed(request);
    }

    protected String buildAuthorizationHeaderValue(Request request) throws IOException {
        if (request.tag(RequestOrigin.class) == RequestOrigin.LOGIN) {
            return null;
        }
        return "Bearer " + (request.tag(RequestOrigin.class) == RequestOrigin.MANAGEMENT ? this.getFreshManagementToken() : this.getFreshLoadTestToken());
    }

    private String getFreshManagementToken() throws IOException {
        if (this.managementToken == null || this.isExpiredToken(this.managementToken)) {
            this.managementToken = this.getNewToken("management");
        }
        return this.managementToken;
    }

    private String getFreshLoadTestToken() throws IOException {
        if (this.loadTestToken == null || this.isExpiredToken(this.loadTestToken)) {
            this.loadTestToken = this.getNewToken("cnt-prod.loadtesting");
        }
        return this.loadTestToken;
    }

    private boolean isExpiredToken(String token) {
        try {
            String[] chunks = token.split("\\.");
            Base64.Decoder decoder = Base64.getUrlDecoder();
            String payload = new String(decoder.decode(chunks[1]), StandardCharsets.UTF_8);
            long expirationEpochSeconds = new ObjectMapper().readTree(payload).get("exp").asLong();
            return Instant.ofEpochSecond(expirationEpochSeconds).isBefore(Instant.now());
        }
        catch (JsonProcessingException e) {
            LOG.warn("Could not check validity of token", (Throwable)e);
            return false;
        }
    }

    private String getNewToken(String scope) throws IOException {
        String scopeUri = String.format("https://%s.azure.com/.default", scope);
        Token token = (Token)this.execApiCall(this.loginApi.getToken(scopeUri, this.clientId, this.clientSecret, "client_credentials", RequestOrigin.LOGIN));
        return token.getAccessToken();
    }

    public Subscription findSubscription() throws IOException {
        return ((ResponseList)this.execApiCall(this.managementApi.findSubscriptions(RequestOrigin.MANAGEMENT))).getFirstElement().orElse(null);
    }

    public ResourceGroup findResourceGroup(String name, Subscription subscription) throws IOException {
        return this.execOptionalApiCall(this.managementApi.findResourceGroup(subscription.getId(), name, RequestOrigin.MANAGEMENT)).map(g -> {
            g.setName(name);
            g.setSubscription(subscription);
            return g;
        }).orElse(null);
    }

    private <T> Optional<T> execOptionalApiCall(Call<T> call) throws IOException {
        retrofit2.Response response = call.execute();
        if (!response.isSuccessful()) {
            if (response.code() == 404) {
                return Optional.empty();
            }
            ResponseBody errorBody = response.errorBody();
            Throwable throwable = null;
            try {
                try {
                    throw this.buildRemoteEngineException(response.code(), errorBody.string());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (errorBody != null) {
                    if (throwable != null) {
                        try {
                            errorBody.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        errorBody.close();
                    }
                }
                throw throwable3;
            }
        }
        return Optional.ofNullable(response.body());
    }

    public Location findLocation(Subscription subscription) throws IOException {
        return ((ResponseList)this.execApiCall(this.managementApi.findLocations(subscription.getId(), RequestOrigin.MANAGEMENT))).getFirstElement().orElse(null);
    }

    public void createResourceGroup(ResourceGroup resourceGroup) throws IOException {
        ResourceGroup created = (ResourceGroup)this.execApiCall(this.managementApi.createResourceGroup(resourceGroup.getSubscription().getId(), resourceGroup.getName(), resourceGroup, RequestOrigin.MANAGEMENT));
        resourceGroup.setProvisioningState(created.getProvisioningState());
    }

    public LoadTestResource findTestResource(String name, ResourceGroup resourceGroup) throws IOException {
        return this.execOptionalApiCall(this.managementApi.findTestResource(resourceGroup.getSubscription().getId(), resourceGroup.getName(), name, RequestOrigin.MANAGEMENT)).map(r -> {
            r.setResourceGroup(resourceGroup);
            this.setLoadTestResource((LoadTestResource)r);
            return r;
        }).orElse(null);
    }

    private void setLoadTestResource(LoadTestResource r) {
        this.dataPlaneUrl = String.format("https://%s", r.getDataPlaneUri());
        this.loadTestApi = (LoadTestApi)this.buildApiFor(this.dataPlaneUrl + "/", LoadTestApi.class);
    }

    public String getDataPlaneUrl() {
        return this.dataPlaneUrl;
    }

    public void createTestResource(LoadTestResource testResource) throws IOException {
        LoadTestResource created = (LoadTestResource)this.execApiCall(this.managementApi.createTestResource(testResource.getResourceGroup().getSubscription().getId(), testResource.getResourceGroup().getName(), testResource.getName(), testResource, RequestOrigin.MANAGEMENT));
        testResource.setId(created.getId());
        testResource.setProvisioningState(created.getProvisioningState());
        this.setLoadTestResource(created);
    }

    public LoadTest findTestByName(String testName, LoadTestResource testResource) throws IOException {
        return ((ResponseList)this.execApiCall(this.loadTestApi.findTestByName(testName))).stream().filter(t -> testName.equals(t.getDisplayName())).peek(t -> t.setTestResource(testResource)).findAny().orElse(null);
    }

    public void updateTest(LoadTest loadTest) throws IOException {
        this.execApiCall(this.loadTestApi.updateTest(loadTest.getTestId(), loadTest));
    }

    public void updateAppComponents(String testId, AppComponents appComponents) throws IOException {
        this.execApiCall(this.loadTestApi.updateAppComponents(testId, appComponents));
    }

    public AppComponents findTestAppComponents(String testId) throws IOException {
        return this.execOptionalApiCall(this.loadTestApi.findTestAppComponents(testId)).orElse(new AppComponents(Collections.emptyList()));
    }

    public List<String> findTestFiles(String testId) throws IOException {
        return ((ResponseList)this.execApiCall(this.loadTestApi.findTestFiles(testId))).stream().map(FileInfo::getFileName).collect(Collectors.toList());
    }

    public void deleteTestFile(String fileName, String testId) throws IOException {
        this.execApiCall(this.loadTestApi.deleteTestFile(testId, fileName));
    }

    public FileInfo uploadTestFile(File file, String fileName, String testId) throws IOException {
        return (FileInfo)this.execApiCall(this.loadTestApi.uploadTestFile(testId, fileName, RequestBody.create((MediaType)MediaType.get((String)"application/octet-stream"), (File)file)));
    }

    public FileInfo findTestFile(String fileName, String testId) throws IOException {
        return (FileInfo)this.execApiCall(this.loadTestApi.findTestFile(testId, fileName));
    }

    public TestRun createTestRun(TestRun testRun) throws IOException {
        return (TestRun)this.execApiCall(this.loadTestApi.createTestRun(testRun.getId(), this.tenantId, testRun));
    }

    public TestRun findTestRunById(String id) throws IOException {
        return (TestRun)this.execApiCall(this.loadTestApi.findTestRunById(id));
    }

    public void stopTestRun(String id) throws IOException {
        this.execApiCall(this.loadTestApi.stopTestRun(id));
    }

    private static interface LoadTestApi {
        public static final String API_VERSION = "?api-version=2022-11-01";
        public static final String MERGE_PATCH_CONTENT_TYPE_HEADER = "content-type: application/merge-patch+json";

        @GET(value="tests?api-version=2022-11-01")
        public Call<ResponseList<LoadTest>> findTestByName(@Query(value="search") String var1);

        @PATCH(value="tests/{testId}?api-version=2022-11-01")
        @Headers(value={"content-type: application/merge-patch+json"})
        public Call<Void> updateTest(@Path(value="testId") String var1, @Body LoadTest var2);

        @PATCH(value="tests/{testId}/app-components?api-version=2022-11-01")
        @Headers(value={"content-type: application/merge-patch+json"})
        public Call<Void> updateAppComponents(@Path(value="testId") String var1, @Body AppComponents var2);

        @GET(value="tests/{testId}/app-components?api-version=2022-11-01")
        public Call<AppComponents> findTestAppComponents(@Path(value="testId") String var1);

        @GET(value="tests/{testId}/files?api-version=2022-11-01")
        public Call<ResponseList<FileInfo>> findTestFiles(@Path(value="testId") String var1);

        @DELETE(value="tests/{testId}/files/{fileName}?api-version=2022-11-01")
        public Call<Void> deleteTestFile(@Path(value="testId") String var1, @Path(value="fileName") String var2);

        @PUT(value="tests/{testId}/files/{fileName}?api-version=2022-11-01")
        public Call<FileInfo> uploadTestFile(@Path(value="testId") String var1, @Path(value="fileName") String var2, @Body RequestBody var3);

        @GET(value="tests/{testId}/files/{fileName}?api-version=2022-11-01")
        public Call<FileInfo> findTestFile(@Path(value="testId") String var1, @Path(value="fileName") String var2);

        @PATCH(value="test-runs/{testRunId}?api-version=2022-11-01")
        @Headers(value={"content-type: application/merge-patch+json"})
        public Call<TestRun> createTestRun(@Path(value="testRunId") String var1, @Query(value="tenantId") String var2, @Body TestRun var3);

        @GET(value="test-runs/{testRunId}?api-version=2022-11-01")
        public Call<TestRun> findTestRunById(@Path(value="testRunId") String var1);

        @POST(value="test-runs/{testRunId}:stop?api-version=2022-11-01")
        public Call<Void> stopTestRun(@Path(value="testRunId") String var1);
    }

    private static interface ManagementApi {
        public static final String DEFAULT_API_VERSION = "?api-version=2020-01-01";
        public static final String RESOURCE_GROUP_API_VERSION = "?api-version=2021-04-01";
        public static final String LOAD_TESTS_PROVIDER = "Microsoft.LoadTestService";
        public static final String LOAD_TESTS_API_VERSION = "?api-version=2022-12-01";

        @GET(value="subscriptions?api-version=2020-01-01")
        public Call<ResponseList<Subscription>> findSubscriptions(@Tag RequestOrigin var1);

        @GET(value="subscriptions/{subscriptionId}/locations?api-version=2020-01-01")
        public Call<ResponseList<Location>> findLocations(@Path(value="subscriptionId") String var1, @Tag RequestOrigin var2);

        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}?api-version=2021-04-01")
        public Call<ResourceGroup> findResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Tag RequestOrigin var3);

        @PUT(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}?api-version=2021-04-01")
        public Call<ResourceGroup> createResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Body ResourceGroup var3, @Tag RequestOrigin var4);

        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LoadTestService/loadTests/{loadTestName}?api-version=2022-12-01")
        public Call<LoadTestResource> findTestResource(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="loadTestName") String var3, @Tag RequestOrigin var4);

        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LoadTestService/loadTests/{loadTestName}?api-version=2022-12-01")
        public Call<LoadTestResource> createTestResource(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="loadTestName") String var3, @Body LoadTestResource var4, @Tag RequestOrigin var5);
    }

    private static interface LoginApi {
        @POST(value="token")
        @FormUrlEncoded
        public Call<Token> getToken(@Field(value="scope") String var1, @Field(value="client_id") String var2, @Field(value="client_secret") String var3, @Field(value="grant_type") String var4, @Tag RequestOrigin var5);
    }

    private static enum RequestOrigin {
        LOGIN,
        MANAGEMENT;

    }
}

