/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.azure;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.abstracta.jmeter.javadsl.azure.AzureClient;
import us.abstracta.jmeter.javadsl.azure.AzureTestPlanStats;
import us.abstracta.jmeter.javadsl.azure.AzureTestStopper;
import us.abstracta.jmeter.javadsl.azure.api.AppComponents;
import us.abstracta.jmeter.javadsl.azure.api.AzureResource;
import us.abstracta.jmeter.javadsl.azure.api.FileInfo;
import us.abstracta.jmeter.javadsl.azure.api.LoadTest;
import us.abstracta.jmeter.javadsl.azure.api.LoadTestResource;
import us.abstracta.jmeter.javadsl.azure.api.Location;
import us.abstracta.jmeter.javadsl.azure.api.ResourceGroup;
import us.abstracta.jmeter.javadsl.azure.api.Subscription;
import us.abstracta.jmeter.javadsl.azure.api.TestRun;
import us.abstracta.jmeter.javadsl.core.BuildTreeContext;
import us.abstracta.jmeter.javadsl.core.DslTestPlan;
import us.abstracta.jmeter.javadsl.core.engines.TestStopper;
import us.abstracta.jmeter.javadsl.engines.BaseRemoteEngine;

public class AzureEngine
extends BaseRemoteEngine<AzureClient, AzureTestPlanStats> {
    private static final Logger LOG = LoggerFactory.getLogger(AzureEngine.class);
    private static final String DEFAULT_NAME = "jmeter-java-dsl";
    private static final Duration STATUS_POLL_PERIOD = Duration.ofSeconds(5L);
    private static final Duration PROVISIONING_TIMEOUT = Duration.ofMinutes(1L);
    private static final Duration VALIDATION_TIMEOUT = Duration.ofMinutes(10L);
    private static final Duration TEST_END_TIMEOUT = Duration.ofMinutes(2L);
    private final String tenantId;
    private final String clientId;
    private final String clientSecret;
    private String subscriptionId;
    private String resourceGroupName;
    private String location;
    private String testResourceName;
    private String testName = "jmeter-java-dsl";
    private String testRunName;
    private Duration testTimeout = Duration.ofHours(1L);
    private int engines = 1;
    private final List<File> assets = new ArrayList<File>();
    private boolean splitCsvs;
    private final List<String> monitoredResources = new ArrayList<String>();

    public AzureEngine(String credentials) {
        String[] parts = credentials.split(":", 3);
        this.tenantId = parts[0];
        this.clientId = parts[1];
        this.clientSecret = parts[2];
    }

    public AzureEngine(String tenantId, String clientId, String clientSecret) {
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public AzureEngine subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public AzureEngine resourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public AzureEngine location(String location) {
        this.location = location;
        return this;
    }

    public AzureEngine testResourceName(String testResourceName) {
        this.testResourceName = testResourceName;
        return this;
    }

    public AzureEngine testName(String testName) {
        this.testName = testName;
        return this;
    }

    public AzureEngine testRunName(String testRunName) {
        this.testRunName = testRunName;
        return this;
    }

    public AzureEngine testTimeout(Duration duration) {
        this.testTimeout = duration;
        return this;
    }

    public AzureEngine engines(int count) {
        this.engines = count;
        return this;
    }

    public AzureEngine assets(File ... files) {
        this.assets.addAll(Arrays.asList(files));
        return this;
    }

    public AzureEngine splitCsvsBetweenEngines(boolean enabled) {
        this.splitCsvs = enabled;
        return this;
    }

    public AzureEngine monitoredResources(String ... resourceIds) {
        this.monitoredResources.addAll(Arrays.asList(resourceIds));
        return this;
    }

    protected HashTree buildTree(DslTestPlan testPlan, BuildTreeContext context) {
        HashTree ret = super.buildTree(testPlan, context);
        if (this.isAutoStoppableTest(ret)) {
            AzureTestStopper.addClientSecretVariableToTree(ret, context);
        }
        return ret;
    }

    protected AzureClient buildClient() {
        return new AzureClient(this.tenantId, this.clientId, this.clientSecret);
    }

    protected TestStopper buildTestStopper() {
        return new AzureTestStopper();
    }

    protected AzureTestPlanStats run(File jmxFile, HashTree tree, BuildTreeContext context) throws IOException, InterruptedException, TimeoutException {
        LoadTest loadTest;
        LoadTestResource testResource;
        Subscription subscription = this.subscriptionId != null ? new Subscription(this.subscriptionId, this.tenantId) : ((AzureClient)this.apiClient).findSubscription();
        String resourceName = this.testResourceName != null ? this.testResourceName : this.testName;
        String groupName = this.resourceGroupName != null ? this.resourceGroupName : resourceName + "-rg";
        ResourceGroup resourceGroup = ((AzureClient)this.apiClient).findResourceGroup(groupName, subscription);
        if (resourceGroup == null) {
            resourceGroup = this.createResourceGroup(groupName, subscription);
        }
        if ((testResource = ((AzureClient)this.apiClient).findTestResource(resourceName, resourceGroup)) == null) {
            testResource = this.createTestResource(resourceName, resourceGroup);
        }
        if ((loadTest = ((AzureClient)this.apiClient).findTestByName(this.testName, testResource)) == null) {
            loadTest = this.createLoadTest(testResource);
            if (!this.monitoredResources.isEmpty()) {
                ((AzureClient)this.apiClient).updateAppComponents(loadTest.getTestId(), new AppComponents(this.monitoredResources));
            }
        } else {
            this.updateLoadTest(loadTest);
            this.clearTestFiles(loadTest);
            this.updateAppComponents(loadTest);
        }
        this.uploadTestFiles(jmxFile, tree, context, loadTest);
        TestRun testRun = new TestRun(loadTest.getTestId(), this.solveTestRunName());
        if (this.isAutoStoppableTest(tree)) {
            AzureTestStopper.setupTestRun(testRun, this.tenantId, this.clientId, this.clientSecret, ((AzureClient)this.apiClient).getDataPlaneUrl());
        }
        if (!(testRun = ((AzureClient)this.apiClient).createTestRun(testRun)).isAccepted()) {
            throw new IllegalStateException("The test run was not accepted. Check your usage of Azure quotas.");
        }
        LOG.info("Started test run {}", (Object)testRun.getUrl());
        testRun = this.awaitTestEnd(testRun);
        LOG.info("Test run completed");
        return new AzureTestPlanStats(testRun);
    }

    private ResourceGroup createResourceGroup(String groupName, Subscription subscription) throws IOException, InterruptedException, TimeoutException {
        Location location = this.location != null ? new Location(this.location) : ((AzureClient)this.apiClient).findLocation(subscription);
        ResourceGroup ret = new ResourceGroup(groupName, location, subscription);
        ((AzureClient)this.apiClient).createResourceGroup(ret);
        LOG.info("Created resource group {}", (Object)ret.getUrl());
        this.awaitProvisionedResourceGroup(ret);
        return ret;
    }

    private void awaitProvisionedResourceGroup(ResourceGroup group) throws IOException, InterruptedException, TimeoutException {
        this.awaitStatus(group, () -> ((AzureClient)this.apiClient).findResourceGroup(group.getName(), group.getSubscription()), AzureResource::isPendingProvisioning, AzureResource::isProvisioned, PROVISIONING_TIMEOUT, "resource group provisioning", "Azure usage", null);
    }

    private <T> void awaitStatus(T entity, EntityProvider<T> entityProvider, Predicate<T> checkIntermediateStatus, Predicate<T> checkSuccessStatus, Duration timeout, String waitName, String detailsName, Function<T, String> failureDetailExtractor) throws InterruptedException, TimeoutException, IOException {
        if (checkSuccessStatus.test(entity)) {
            return;
        }
        LOG.info("Waiting for {}... ", (Object)waitName);
        Instant start = Instant.now();
        while (!this.hasTimedOut(timeout, start) && checkIntermediateStatus.test(entity)) {
            Thread.sleep(STATUS_POLL_PERIOD.toMillis());
            entity = entityProvider.get();
        }
        if (checkIntermediateStatus.test(entity)) {
            throw new TimeoutException(String.format("Timeout while waiting for %s after %s. You may try executing again, or create an issue in jmeter-java-dsl GitHub repository with %s details.", waitName, this.prettyDuration(timeout), detailsName));
        }
        if (!checkSuccessStatus.test(entity)) {
            String failureDetails = failureDetailExtractor != null ? failureDetailExtractor.apply(entity) : null;
            throw new IllegalArgumentException(String.format("%s failed%s. Create an issue in jmeter-java-dsl GitHub repository with %s details.", this.firstLetterToUpper(waitName), failureDetails != null ? " due to: " + failureDetails : "", detailsName));
        }
    }

    private String firstLetterToUpper(String str) {
        return str.substring(0, 1).toUpperCase(Locale.US) + str.substring(1);
    }

    private LoadTestResource createTestResource(String resourceName, ResourceGroup resourceGroup) throws IOException, InterruptedException, TimeoutException {
        LoadTestResource ret = new LoadTestResource(resourceName, resourceGroup);
        ((AzureClient)this.apiClient).createTestResource(ret);
        LOG.info("Created test resource {}", (Object)ret.getUrl());
        this.awaitProvisionedTestResource(ret);
        return ret;
    }

    private void awaitProvisionedTestResource(LoadTestResource testResource) throws IOException, InterruptedException, TimeoutException {
        this.awaitStatus(testResource, () -> ((AzureClient)this.apiClient).findTestResource(testResource.getName(), testResource.getResourceGroup()), AzureResource::isPendingProvisioning, AzureResource::isProvisioned, PROVISIONING_TIMEOUT, "test resource provisioning", "Azure usage", null);
    }

    private LoadTest createLoadTest(LoadTestResource testResource) throws IOException {
        LoadTest ret = new LoadTest(this.testName, this.engines, this.splitCsvs, testResource);
        ((AzureClient)this.apiClient).updateTest(ret);
        LOG.info("Created test {}", (Object)ret.getUrl());
        return ret;
    }

    private void updateLoadTest(LoadTest loadTest) throws IOException {
        LOG.info("Updating test {}", (Object)loadTest.getUrl());
        int prevEngines = loadTest.getEngineInstances();
        boolean prevSplitCsvs = loadTest.isSplitCsvs();
        loadTest.setEngineInstances(this.engines);
        loadTest.setSplitCsvs(this.splitCsvs);
        if (prevSplitCsvs != this.splitCsvs || prevEngines != this.engines) {
            ((AzureClient)this.apiClient).updateTest(loadTest);
        }
    }

    private void clearTestFiles(LoadTest loadTest) throws IOException {
        for (String f : ((AzureClient)this.apiClient).findTestFiles(loadTest.getTestId())) {
            ((AzureClient)this.apiClient).deleteTestFile(f, loadTest.getTestId());
        }
    }

    private void updateAppComponents(LoadTest loadTest) throws IOException {
        AppComponents components = ((AzureClient)this.apiClient).findTestAppComponents(loadTest.getTestId());
        if (components.updateWith(this.monitoredResources)) {
            ((AzureClient)this.apiClient).updateAppComponents(loadTest.getTestId(), components);
        }
    }

    private void uploadTestFiles(File jmxFile, HashTree tree, BuildTreeContext context, LoadTest loadTest) throws IOException, InterruptedException, TimeoutException {
        for (File file : this.assets) {
            context.processAssetFile(file.getPath());
        }
        for (File file : this.findDependencies(tree, context)) {
            context.processAssetFile(file.getPath());
        }
        context.processAssetFile(jmxFile.getPath());
        for (Map.Entry entry : context.getAssetFiles().entrySet()) {
            FileInfo testFile = ((AzureClient)this.apiClient).uploadTestFile((File)entry.getValue(), (String)entry.getKey(), loadTest.getTestId());
            this.awaitValidatedTestFile(testFile, loadTest.getTestId());
        }
    }

    private void awaitValidatedTestFile(FileInfo testFile, String testId) throws IOException, InterruptedException, TimeoutException {
        String fileName = testFile.getFileName();
        this.awaitStatus(testFile, () -> ((AzureClient)this.apiClient).findTestFile(fileName, testId), FileInfo::isPendingValidation, FileInfo::isSuccessValidation, VALIDATION_TIMEOUT, "test file '" + fileName + "' validation", "test plan", FileInfo::getValidationFailureDetails);
    }

    private String solveTestRunName() {
        return this.testRunName != null ? this.testRunName : "TestRun_" + new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss").format(Date.from(Instant.now()));
    }

    private TestRun awaitTestEnd(TestRun testRun) throws InterruptedException, IOException, TimeoutException {
        Instant start = Instant.now();
        while (!testRun.isEnded() && !this.hasTimedOut(this.testTimeout, start)) {
            Thread.sleep(STATUS_POLL_PERIOD.toMillis());
            testRun = ((AzureClient)this.apiClient).findTestRunById(testRun.getId());
        }
        if (!testRun.isEnded()) {
            String prettyTimeout = this.prettyDuration(this.testTimeout);
            LOG.warn("Test execution timed out after {} with status {}. Stopping test run ...", (Object)prettyTimeout, (Object)testRun.getStatus());
            ((AzureClient)this.apiClient).stopTestRun(testRun.getId());
            LOG.info("Test run stopped.");
            throw new TimeoutException("Test execution timed out after " + prettyTimeout);
        }
        AzureTestStopper.handleTestEnd(testRun);
        return this.awaitVirtualUsers(testRun);
    }

    private TestRun awaitVirtualUsers(TestRun testRun) throws InterruptedException, IOException {
        Instant start = Instant.now();
        while (testRun.getVirtualUsers() == null && !this.hasTimedOut(TEST_END_TIMEOUT, start)) {
            Thread.sleep(STATUS_POLL_PERIOD.toMillis());
            testRun = ((AzureClient)this.apiClient).findTestRunById(testRun.getId());
        }
        if (!testRun.isSuccess()) {
            throw new IllegalStateException("Test " + testRun.getStatus().toLowerCase());
        }
        return testRun;
    }

    private static interface EntityProvider<T> {
        public T get() throws IOException;
    }
}

