/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.azure.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public abstract class AzureResource {
    @JsonIgnore
    protected AzureResourceProperties properties;

    protected AzureResource(AzureResourceProperties properties) {
        this.properties = properties;
    }

    @JsonIgnore
    public String getProvisioningState() {
        return this.properties.provisioningState;
    }

    public void setProvisioningState(String provisioningState) {
        this.properties.provisioningState = provisioningState;
    }

    @JsonIgnore
    public boolean isPendingProvisioning() {
        String lowerState = this.properties.provisioningState.toLowerCase();
        return !"succeeded".equals(lowerState) && !"failed".equals(lowerState) && !"canceled".equals(lowerState);
    }

    @JsonIgnore
    public boolean isProvisioned() {
        return "succeeded".equalsIgnoreCase(this.properties.provisioningState);
    }

    public static class AzureResourceProperties {
        private String provisioningState;

        @JsonCreator
        public AzureResourceProperties(@JsonProperty(value="provisioningState") String provisioningState) {
            this.provisioningState = provisioningState;
        }
    }
}

