/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.azure.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import us.abstracta.jmeter.javadsl.azure.api.LoadTestResource;

public class LoadTest {
    private final String testId;
    private final String displayName;
    private final LoadTestConfiguration loadTestConfiguration;
    @JsonIgnore
    private LoadTestResource testResource;

    @JsonCreator
    public LoadTest(@JsonProperty(value="testId") String testId, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="loadTestConfiguration") LoadTestConfiguration loadTestConfiguration) {
        this.testId = testId;
        this.displayName = displayName;
        this.loadTestConfiguration = loadTestConfiguration;
    }

    public LoadTest(String displayName, int engineInstances, boolean splitAllCsvs, LoadTestResource testResource) {
        this(UUID.randomUUID().toString(), displayName, new LoadTestConfiguration(engineInstances, splitAllCsvs));
        this.testResource = testResource;
    }

    public String getTestId() {
        return this.testId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @JsonIgnore
    public int getEngineInstances() {
        return this.loadTestConfiguration.engineInstances;
    }

    @JsonIgnore
    public void setEngineInstances(int engineInstances) {
        this.loadTestConfiguration.engineInstances = engineInstances;
    }

    @JsonIgnore
    public boolean isSplitCsvs() {
        return this.loadTestConfiguration.splitAllCSVs;
    }

    @JsonIgnore
    public void setSplitCsvs(boolean splitCsvs) {
        this.loadTestConfiguration.splitAllCSVs = splitCsvs;
    }

    @JsonIgnore
    public void setTestResource(LoadTestResource testResource) {
        this.testResource = testResource;
    }

    @JsonIgnore
    public String getUrl() {
        try {
            return String.format("https://portal.azure.com/#view/Microsoft_Azure_CloudNativeTesting/TestRun/testId/%s/resourceId/%s/openingFromBlade~/true/openingFromTestBlade~/true;", this.testId, URLEncoder.encode(this.testResource.getId(), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class LoadTestConfiguration {
        private int engineInstances;
        private boolean splitAllCSVs;

        @JsonCreator
        public LoadTestConfiguration(@JsonProperty(value="engineInstances") int engineInstances, @JsonProperty(value="splitAllCSVs") boolean splitAllCSVs) {
            this.engineInstances = engineInstances;
            this.splitAllCSVs = splitAllCSVs;
        }
    }
}

