/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.azure.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import us.abstracta.jmeter.javadsl.azure.api.AzureResource;
import us.abstracta.jmeter.javadsl.azure.api.ResourceGroup;

public class LoadTestResource
extends AzureResource {
    @JsonIgnore
    private String id;
    @JsonIgnore
    private final String name;
    @JsonIgnore
    private ResourceGroup resourceGroup;
    private String location;

    @JsonCreator
    public LoadTestResource(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="properties") LoadTestResourceProperties properties) {
        super(properties);
        this.id = id;
        this.name = name;
    }

    public LoadTestResource(String name, ResourceGroup resourceGroup) {
        super(new LoadTestResourceProperties(null, null));
        this.name = name;
        this.resourceGroup = resourceGroup;
        this.location = resourceGroup.getLocation();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public ResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    public void setResourceGroup(ResourceGroup resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    @JsonIgnore
    public String getDataPlaneUri() {
        return ((LoadTestResourceProperties)this.properties).dataPlaneUri;
    }

    @JsonIgnore
    public String getUrl() {
        return this.resourceGroup.getUrl() + "/providers/Microsoft.LoadTestService/loadtests/" + this.name;
    }

    public static class LoadTestResourceProperties
    extends AzureResource.AzureResourceProperties {
        private final String dataPlaneUri;

        @JsonCreator
        public LoadTestResourceProperties(@JsonProperty(value="provisioningState") String provisioningState, @JsonProperty(value="dataPlaneURI") String dataPlaneUri) {
            super(provisioningState);
            this.dataPlaneUri = dataPlaneUri;
        }
    }
}

