/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.azure.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import us.abstracta.jmeter.javadsl.azure.api.Secret;
import us.abstracta.jmeter.javadsl.azure.api.TransactionStats;

public class TestRun {
    private final String testRunId;
    private final String displayName;
    private final String testId;
    private Map<String, String> environmentVariables;
    private Map<String, Secret> secrets;
    private final String status;
    private final Integer virtualUsers;
    private final Instant startDateTime;
    private final Instant endDateTime;
    private final Map<String, TransactionStats> testRunStatistics;
    private final String portalUrl;

    public TestRun(String testId, String name) {
        this(UUID.randomUUID().toString(), name, testId, "ACCEPTED", null, null, null, null, Collections.emptyMap());
    }

    @JsonCreator
    public TestRun(@JsonProperty(value="testRunId") String id, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="testId") String testId, @JsonProperty(value="status") String status, @JsonProperty(value="virtualUsers") Integer virtualUsers, @JsonProperty(value="startDateTime") Instant startDateTime, @JsonProperty(value="endDateTime") Instant endDateTime, @JsonProperty(value="portalUrl") String portalUrl, @JsonProperty(value="testRunStatistics") Map<String, TransactionStats> testRunStatistics) {
        this.testRunId = id;
        this.displayName = displayName;
        this.testId = testId;
        this.status = status;
        this.virtualUsers = virtualUsers;
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
        this.portalUrl = portalUrl;
        this.testRunStatistics = testRunStatistics;
    }

    public String getId() {
        return this.testRunId;
    }

    public String getTestId() {
        return this.testId;
    }

    @JsonIgnore
    public boolean isAccepted() {
        return "ACCEPTED".equals(this.status);
    }

    @JsonIgnore
    public boolean isEnded() {
        return "DONE".equals(this.status) || "FAILED".equals(this.status) || "CANCELLED".equals(this.status);
    }

    @JsonIgnore
    public boolean isSuccess() {
        return "DONE".equals(this.status);
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getVirtualUsers() {
        return this.virtualUsers;
    }

    public Map<String, TransactionStats> getTestRunStatistics() {
        return this.testRunStatistics;
    }

    public Instant getStartTime() {
        return this.startDateTime;
    }

    public Instant getEndTime() {
        return this.endDateTime;
    }

    public String getUrl() {
        return this.portalUrl;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> vars) {
        this.environmentVariables = vars;
    }

    public void setSecrets(Map<String, Secret> secrets) {
        this.secrets = secrets;
    }
}

