/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.engines;

import java.time.Instant;
import org.apache.jmeter.samplers.SampleResult;
import us.abstracta.jmeter.javadsl.core.stats.CountMetricSummary;
import us.abstracta.jmeter.javadsl.core.stats.StatsSummary;
import us.abstracta.jmeter.javadsl.engines.RemoteEngineTimeMetricSummary;

public abstract class BaseRemoteEngineStatsSummary
implements StatsSummary {
    protected final Instant firstTime;
    protected final Instant endTime;
    protected final CountMetricSummary samples = new CountMetricSummary();
    protected final CountMetricSummary errors = new CountMetricSummary();
    protected final CountMetricSummary receivedBytes = new CountMetricSummary();
    protected final CountMetricSummary sentBytes = new CountMetricSummary();
    protected final RemoteEngineTimeMetricSummary sampleTime;

    protected BaseRemoteEngineStatsSummary(Instant firstTime, Instant endTime, long elapsedTimeMillis, long sampleCount, long errorCount, long minResponseTime, long maxResponseTime, double meanResponseTime, double medianResponseTime, double responseTimePerc90, double responseTimePerc95, double responseTimePerc99, double receivedBytesPerSec, double sentBytesPerSec) {
        this.firstTime = firstTime;
        this.endTime = endTime;
        this.samples.increment(sampleCount, elapsedTimeMillis);
        this.errors.increment(errorCount, elapsedTimeMillis);
        this.sampleTime = new RemoteEngineTimeMetricSummary(minResponseTime, maxResponseTime, meanResponseTime, medianResponseTime, responseTimePerc90, responseTimePerc95, responseTimePerc99);
        this.receivedBytes.increment(BaseRemoteEngineStatsSummary.perSecond2Total(receivedBytesPerSec, elapsedTimeMillis), elapsedTimeMillis);
        this.sentBytes.increment(BaseRemoteEngineStatsSummary.perSecond2Total(sentBytesPerSec, elapsedTimeMillis), elapsedTimeMillis);
    }

    private static long perSecond2Total(double avgBytes, long elapsedTimeMillis) {
        return Math.round(avgBytes / 1000.0 * (double)elapsedTimeMillis);
    }

    public void add(SampleResult result) {
    }

    public Instant firstTime() {
        return this.firstTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public CountMetricSummary samples() {
        return this.samples;
    }

    public CountMetricSummary errors() {
        return this.errors;
    }

    public RemoteEngineTimeMetricSummary sampleTime() {
        return this.sampleTime;
    }

    public CountMetricSummary receivedBytes() {
        return this.receivedBytes;
    }

    public CountMetricSummary sentBytes() {
        return this.sentBytes;
    }
}

