/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.engines;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import devcsrj.okhttp3.logging.HttpLoggingInterceptor;
import java.io.Closeable;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import us.abstracta.jmeter.javadsl.engines.RemoteEngineException;

public abstract class BaseRemoteEngineApiClient
implements Closeable {
    private final Logger logger;
    private final OkHttpClient httpClient;

    protected BaseRemoteEngineApiClient(Logger logger) {
        this.logger = logger;
        OkHttpClient.Builder cliBuilder = new OkHttpClient.Builder();
        this.configureHttpClient(cliBuilder);
        this.httpClient = cliBuilder.build();
    }

    protected void configureHttpClient(OkHttpClient.Builder builder) {
        builder.addInterceptor(this::authorizationInterceptor);
        if (this.logger.isDebugEnabled()) {
            builder.addInterceptor((Interceptor)new HttpLoggingInterceptor());
        }
    }

    private Response authorizationInterceptor(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String auth = this.buildAuthorizationHeaderValue(request);
        if (auth != null) {
            request = request.newBuilder().header("Authorization", auth).build();
        }
        return chain.proceed(request);
    }

    protected abstract String buildAuthorizationHeaderValue(Request var1) throws IOException;

    protected <T> T buildApiFor(String baseUrl, Class<T> apiClass) {
        return (T)new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)this.buildConverterMapper())).client(this.httpClient).build().create(apiClass);
    }

    protected ObjectMapper buildConverterMapper() {
        return new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JavaTimeModule());
    }

    protected <T> T execApiCall(Call<T> call) throws IOException {
        retrofit2.Response response = call.execute();
        if (!response.isSuccessful()) {
            ResponseBody errorBody = response.errorBody();
            try {
                throw this.buildRemoteEngineException(response.code(), errorBody.string());
            }
            catch (Throwable throwable) {
                if (errorBody != null) {
                    try {
                        errorBody.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        return (T)response.body();
    }

    protected RemoteEngineException buildRemoteEngineException(int code, String message) {
        return new RemoteEngineException(code, message);
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }
}

