/*
 * Decompiled with CFR 0.152.
 */
package us.abstracta.jmeter.javadsl.jdbc;

import java.sql.Driver;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.jmeter.protocol.jdbc.config.DataSourceElement;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import us.abstracta.jmeter.javadsl.core.configs.BaseConfigElement;

public class DslJdbcConnectionPool
extends BaseConfigElement {
    private static final Map<Integer, String> TRANSACTION_ISOLATION_TO_PROPERTY_VALUE = DslJdbcConnectionPool.buildTransactionIsolationToPropertyValueMapping();
    private final Class<? extends Driver> driverClass;
    private final String url;
    private String user;
    private String password;
    private boolean autoCommit = true;
    private int maxConnections;
    private Duration maxConnectionWait = Duration.ofSeconds(10L);
    private int transactionIsolation = -1;

    public DslJdbcConnectionPool(String name, Class<? extends Driver> driverClass, String url) {
        super(name, TestBeanGUI.class);
        this.driverClass = driverClass;
        this.url = url;
    }

    private static Map<Integer, String> buildTransactionIsolationToPropertyValueMapping() {
        HashMap<Integer, String> ret = new HashMap<Integer, String>();
        ret.put(-1, "DEFAULT");
        ret.put(0, "TRANSACTION_NONE");
        ret.put(2, "TRANSACTION_READ_COMMITTED");
        ret.put(1, "TRANSACTION_READ_UNCOMMITTED");
        ret.put(4, "TRANSACTION_REPEATABLE_READ");
        ret.put(8, "TRANSACTION_SERIALIZABLE");
        return ret;
    }

    public DslJdbcConnectionPool user(String user) {
        this.user = user;
        return this;
    }

    public DslJdbcConnectionPool password(String password) {
        this.password = password;
        return this;
    }

    public DslJdbcConnectionPool autoCommit(boolean enabled) {
        this.autoCommit = enabled;
        return this;
    }

    public DslJdbcConnectionPool maxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public DslJdbcConnectionPool maxConnectionWait(Duration maxConnectionWait) {
        this.maxConnectionWait = maxConnectionWait;
        return this;
    }

    public DslJdbcConnectionPool transactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
        return this;
    }

    protected TestElement buildTestElement() {
        DataSourceElement ret = new DataSourceElement();
        ret.setDataSource(this.name);
        ret.setDriver(this.driverClass.getName());
        ret.setDbUrl(this.url);
        ret.setUsername(this.user);
        ret.setPassword(this.password);
        ret.setAutocommit(this.autoCommit);
        ret.setPoolMax(String.valueOf(this.maxConnections));
        ret.setTimeout(String.valueOf(this.maxConnectionWait.toMillis()));
        ret.setTransactionIsolation(this.transactionIsolationToPropertyValue(this.transactionIsolation));
        ret.setPreinit(true);
        return ret;
    }

    private String transactionIsolationToPropertyValue(int val) {
        return Optional.ofNullable(TRANSACTION_ISOLATION_TO_PROPERTY_VALUE.get(val)).orElseThrow(() -> new IllegalArgumentException("Unknown transaction level " + val + " for pool " + this.name));
    }
}

