/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.threads;

import com.blazemeter.jmeter.reporters.FlushingResultCollector;
import com.blazemeter.jmeter.threads.DynamicThread;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicThreadGroupModel
extends AbstractThreadGroup
implements TestStateListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractDynamicThreadGroupModel.class);
    protected static final long WAIT_TO_DIE = JMeterUtils.getPropDefault("jmeterengine.threadstop.wait", 5000);
    public static final String LOG_FILENAME = "LogFilename";
    public static final String TARGET_LEVEL = "TargetLevel";
    public static final String RAMP_UP = "RampUp";
    public static final String STEPS = "Steps";
    public static final String ITERATIONS = "Iterations";
    public static final String HOLD = "Hold";
    protected transient Set<DynamicThread> threads = Collections.newSetFromMap(new ConcurrentHashMap());
    protected final ResultCollector logFile = new FlushingResultCollector();
    protected volatile boolean running = false;

    public void setLogFilename(String value) {
        this.setProperty(LOG_FILENAME, value);
    }

    public String getLogFilename() {
        return this.getPropertyAsString(LOG_FILENAME);
    }

    protected void saveLogRecord(String marker, String threadName, String arrivalID) {
        SampleResult res = new SampleResult();
        res.sampleStart();
        res.setSampleLabel(arrivalID);
        res.setResponseMessage(marker);
        res.setThreadName(threadName);
        res.sampleEnd();
        SampleEvent evt = new SampleEvent(res, this.getName());
        this.logFile.sampleOccurred(evt);
    }

    @Override
    public void testStarted() {
        this.testStarted("");
    }

    @Override
    public void testStarted(String s) {
        this.logFile.setFilename(this.getLogFilename());
        this.logFile.testStarted(s);
    }

    @Override
    public void testEnded() {
        this.testEnded("");
    }

    @Override
    public void testEnded(String s) {
        this.logFile.testEnded(s);
    }

    @Override
    public int numberOfActiveThreads() {
        return this.threads.size();
    }

    @Override
    public int getNumberOfThreads() {
        return this.threads.size();
    }

    public void addThread(DynamicThread threadWorker) {
        this.threads.add(threadWorker);
    }

    public void setTargetLevel(String value) {
        this.setProperty(TARGET_LEVEL, value.trim());
    }

    public String getTargetLevel() {
        return this.getPropertyAsString(TARGET_LEVEL, "1");
    }

    public int getTargetLevelAsInt() {
        return this.getPropertyAsInt(TARGET_LEVEL, 1);
    }

    public void setRampUp(String value) {
        this.setProperty(RAMP_UP, value.trim());
    }

    public String getRampUp() {
        return this.getPropertyAsString(RAMP_UP, "");
    }

    public long getRampUpSeconds() {
        String val = this.getRampUp();
        if (val.isEmpty()) {
            return 0L;
        }
        return Math.round(Double.parseDouble(val) * this.getUnitFactor());
    }

    public double getUnitFactor() {
        return 1.0;
    }

    public void setSteps(String value) {
        this.setProperty(STEPS, value.trim());
    }

    public String getSteps() {
        return this.getPropertyAsString(STEPS, "");
    }

    public long getStepsAsLong() {
        String val = this.getSteps();
        if (val.isEmpty()) {
            return 0L;
        }
        return Long.parseLong(val);
    }

    public void setHold(String value) {
        this.setProperty(HOLD, value.trim());
    }

    public String getHold() {
        return this.getPropertyAsString(HOLD, "1");
    }

    public long getHoldSeconds() {
        String val = this.getHold();
        if (val.isEmpty()) {
            return 0L;
        }
        return Math.round(Double.parseDouble(val) * this.getUnitFactor());
    }

    public double getTargetLevelAsDouble() {
        return this.getTargetLevelAsInt();
    }

    public double getTargetLevelFactored() {
        return this.getTargetLevelAsDouble() / this.getUnitFactor();
    }

    public long getIterationsLimitAsLong() {
        String val = this.getIterationsLimit();
        if (val.isEmpty()) {
            return 0L;
        }
        return Long.parseLong(val);
    }

    public String getIterationsLimit() {
        return this.getPropertyAsString(ITERATIONS);
    }

    public void setIterationsLimit(String val) {
        this.setProperty(ITERATIONS, val);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.threads = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public boolean isRunning() {
        return this.running;
    }
}

