/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.threads;

import com.blazemeter.jmeter.control.VirtualUserController;
import com.blazemeter.jmeter.threads.AbstractDynamicThreadGroup;
import com.blazemeter.jmeter.threads.DynamicThread;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThreadStarter
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(AbstractThreadStarter.class);
    protected final ListenerNotifier notifier;
    protected final ListedHashTree threadGroupTree;
    protected final StandardJMeterEngine engine;
    protected final JMeterContext context;
    protected final AbstractDynamicThreadGroup owner;
    protected final int groupIndex;
    protected long threadIndex = 0L;
    protected HashTree treeClone;
    protected double startTime = 0.0;

    public AbstractThreadStarter(int groupIndex, AbstractDynamicThreadGroup owner, ListedHashTree listedHashTree, ListenerNotifier listenerNotifier, StandardJMeterEngine standardJMeterEngine) {
        this.owner = owner;
        this.treeClone = this.cloneTree(listedHashTree);
        this.engine = standardJMeterEngine;
        this.groupIndex = groupIndex;
        this.threadGroupTree = listedHashTree;
        this.notifier = listenerNotifier;
        this.context = JMeterContextService.getContext();
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            JMeterContextService.getContext().setVariables(this.context.getVariables());
            this.supplyActiveThreads();
        }
        catch (InterruptedException e) {
            log.debug("Interrupted", e);
            Thread.currentThread().interrupt();
        }
        log.debug("Thread starter has done its job");
    }

    protected abstract void supplyActiveThreads() throws InterruptedException;

    protected DynamicThread makeThread(long threadIndex) {
        boolean onErrorStopTest = this.owner.getOnErrorStopTest();
        boolean onErrorStopTestNow = this.owner.getOnErrorStopTestNow();
        boolean onErrorStopThread = this.owner.getOnErrorStopThread();
        boolean onErrorStartNextLoop = this.owner.getOnErrorStartNextLoop();
        DynamicThread jmeterThread = new DynamicThread(this.treeClone, this.owner, this.notifier);
        jmeterThread.setThreadNum((int)threadIndex);
        jmeterThread.setThreadGroup(this.owner);
        jmeterThread.setInitialContext(this.context);
        String groupName = this.getName();
        String distributedPrefix = JMeterUtils.getPropDefault("__jm.D_TG", "");
        String threadName = distributedPrefix + (distributedPrefix.isEmpty() ? "" : "-") + groupName + " " + this.groupIndex + "-" + (threadIndex + 1L);
        jmeterThread.setThreadName(threadName);
        jmeterThread.setEngine(this.engine);
        jmeterThread.setOnErrorStopTest(onErrorStopTest);
        jmeterThread.setOnErrorStopTestNow(onErrorStopTestNow);
        jmeterThread.setOnErrorStopThread(onErrorStopThread);
        jmeterThread.setOnErrorStartNextLoop(onErrorStartNextLoop);
        return jmeterThread;
    }

    protected ListedHashTree cloneTree(ListedHashTree tree) {
        Object firstElement;
        Controller samplerController;
        TreeCloner cloner = new TreeCloner(true);
        tree.traverse(cloner);
        ListedHashTree clonedTree = cloner.getClonedTree();
        if (!clonedTree.isEmpty() && (samplerController = ((AbstractDynamicThreadGroup)(firstElement = clonedTree.getArray()[0])).getSamplerController()) instanceof VirtualUserController) {
            assert (this.owner != null);
            ((VirtualUserController)samplerController).setOwner(this.owner);
        }
        return clonedTree;
    }

    protected DynamicThread addActiveThread() {
        DynamicThread threadWorker = this.makeThread(this.threadIndex++);
        this.owner.addThread(threadWorker);
        Thread thread = new Thread((Runnable)threadWorker, threadWorker.getThreadName());
        threadWorker.setOSThread(thread);
        thread.setDaemon(false);
        thread.start();
        this.treeClone = this.cloneTree(this.threadGroupTree);
        return threadWorker;
    }
}

