/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.threads.arrivals;

import com.blazemeter.jmeter.threads.AbstractDynamicThreadGroup;
import com.blazemeter.jmeter.threads.AbstractDynamicThreadGroupGui;
import com.blazemeter.jmeter.threads.AdditionalFieldsPanel;
import com.blazemeter.jmeter.threads.LoadParamsFieldsPanel;
import com.blazemeter.jmeter.threads.ParamsPanel;
import com.blazemeter.jmeter.threads.arrivals.ArrivalsThreadGroup;
import java.awt.Color;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrivalsThreadGroupGui
extends AbstractDynamicThreadGroupGui {
    private static final Logger log = LoggerFactory.getLogger(ArrivalsThreadGroupGui.class);

    public ArrivalsThreadGroupGui() {
        JMeterPluginsUtils.addHelpLinkToPanel(this, this.getClass().getSimpleName());
    }

    @Override
    public String getLabelResource() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public String getStaticLabel() {
        return "bzm - Arrivals Thread Group";
    }

    @Override
    protected ArrivalsThreadGroup createThreadGroupObject() {
        return new ArrivalsThreadGroup();
    }

    @Override
    protected AdditionalFieldsPanel getAdditionalFieldsPanel() {
        return new AdditionalFieldsPanel(true);
    }

    @Override
    protected void setChartPropertiesFromTG(AbstractDynamicThreadGroup tg) {
        if (tg instanceof ArrivalsThreadGroup) {
            ArrivalsThreadGroup atg = (ArrivalsThreadGroup)tg;
            this.previewChart.setYAxisLabel("Number of arrivals/" + atg.getUnitStr());
        }
    }

    @Override
    protected Color getRowColor() {
        return Color.MAGENTA;
    }

    @Override
    protected String getRowLabel(double totalArrivals) {
        log.debug("Total arr: " + totalArrivals);
        return "Arrival Rate (~" + Math.round(totalArrivals) + " total arrivals)";
    }

    @Override
    protected ParamsPanel createLoadPanel() {
        LoadParamsFieldsPanel loadFields = new LoadParamsFieldsPanel("Target Rate (arrivals/sec): ", "Ramp Up Time (sec): ", "Hold Target Rate Time (sec): ");
        loadFields.addUpdateListener(this);
        return loadFields;
    }
}

