/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.threads.concurrency;

import com.blazemeter.jmeter.threads.AbstractDynamicThreadGroup;
import com.blazemeter.jmeter.threads.concurrency.ConcurrencyThreadStarter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrencyThreadGroup
extends AbstractDynamicThreadGroup {
    private static final Logger log = LoggerFactory.getLogger(ConcurrencyThreadGroup.class);
    private static final long DEFAULT_TEMPORISATION = JMeterUtils.getPropDefault("dynamic_tg.temporisation", 10L);
    public static final long MIN_CHECK_TIME = 1000L;
    private transient Lock lock = new ReentrantLock();
    private transient Condition condition = this.lock.newCondition();

    @Override
    protected Thread getThreadStarter(int groupIndex, ListenerNotifier listenerNotifier, ListedHashTree testTree, StandardJMeterEngine engine) {
        return new ConcurrencyThreadStarter(groupIndex, listenerNotifier, testTree, engine, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitThreadStopped() {
        long sleepTime = this.threads.isEmpty() ? DEFAULT_TEMPORISATION : 1000L;
        this.lock.lock();
        try {
            this.condition.await(sleepTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.debug("Interrupted", e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getNumThreads() {
        return (int)Math.round(this.getTargetLevelAsDouble());
    }

    @Override
    public boolean isLimitReached() {
        return !this.running || !this.threadStarter.isAlive();
    }

    public void threadStarted(JMeterThread thread) {
        this.saveLogRecord("START", thread.getThreadName(), "");
    }

    @Override
    public void threadFinished(JMeterThread thread) {
        super.threadFinished(thread);
        this.saveLogRecord("FINISH", thread.getThreadName(), "");
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getConcurrency() {
        return this.threads.size();
    }

    public boolean tooMuchConcurrency() {
        return (double)this.threads.size() > this.getTargetLevelAsDouble();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }
}

