/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.threads.concurrency;

import com.blazemeter.jmeter.threads.AbstractThreadStarter;
import com.blazemeter.jmeter.threads.DynamicThread;
import com.blazemeter.jmeter.threads.concurrency.ConcurrencyThreadGroup;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrencyThreadStarter
extends AbstractThreadStarter {
    private static final Logger log = LoggerFactory.getLogger(ConcurrencyThreadStarter.class);
    static final long CACHING_VALIDITY_MS = JMeterUtils.getPropDefault("dynamic_tg.properties_caching_validity", 20L);
    private final ConcurrencyThreadGroup concurrTG;
    private long rampUp;
    private long hold;
    private long steps;
    private double maxConcurr;
    private long lastCachedTime;
    private long defaultShiftRampup;

    public ConcurrencyThreadStarter(int groupIndex, ListenerNotifier listenerNotifier, ListedHashTree testTree, StandardJMeterEngine engine, ConcurrencyThreadGroup concurrencyThreadGroup) {
        super(groupIndex, concurrencyThreadGroup, testTree, listenerNotifier, engine);
        this.concurrTG = concurrencyThreadGroup;
        this.rampUp = this.owner.getRampUpSeconds();
        this.hold = this.owner.getHoldSeconds();
        this.steps = this.owner.getStepsAsLong();
        this.maxConcurr = this.owner.getTargetLevelAsDouble();
        this.defaultShiftRampup = JMeterUtils.getPropDefault("dynamic_tg.shift_rampup_start", 0L);
        this.lastCachedTime = System.currentTimeMillis();
    }

    @Override
    protected void supplyActiveThreads() {
        log.info("Start supplying threads");
        if (this.owner.getTargetLevelAsInt() <= 0) {
            log.info("ThreadStarter will finish, because target concurrency less than 0.");
            return;
        }
        this.startTime = System.currentTimeMillis();
        boolean isDebugEnabled = log.isDebugEnabled();
        while (!this.owner.isLimitReached() && this.getPlannedConcurrency(isDebugEnabled) >= 0L) {
            if (isDebugEnabled) {
                log.debug("Concurrency factual/expected: " + this.concurrTG.getConcurrency() + "/" + this.getPlannedConcurrency(isDebugEnabled));
            }
            while (this.concurrTG.getConcurrency() < this.getPlannedConcurrency(isDebugEnabled)) {
                DynamicThread thread = this.addActiveThread();
                this.concurrTG.threadStarted(thread);
            }
            this.concurrTG.waitThreadStopped();
        }
        log.info("Done supplying threads");
    }

    private long getPlannedConcurrency(boolean isDebugEnabled) {
        long now = System.currentTimeMillis();
        this.checkNeedsPropertiesReloading(now);
        double timeOffset = ((double)now - this.startTime) / 1000.0;
        if (isDebugEnabled) {
            log.debug("Time progress: " + timeOffset + "/" + (this.rampUp + this.hold));
        }
        if ((timeOffset -= (double)this.defaultShiftRampup) < 0.0) {
            timeOffset = 0.0;
        }
        if (timeOffset >= (double)(this.rampUp + this.hold)) {
            return -1L;
        }
        if (this.rampUp == 0L || timeOffset > (double)this.rampUp) {
            return Math.round(this.maxConcurr);
        }
        if (this.steps > 0L) {
            double stepSize = this.maxConcurr / (double)this.steps;
            double stepLen = (double)this.rampUp / (double)this.steps;
            return Math.round(stepSize * (Math.floor(timeOffset / stepLen) + 1.0));
        }
        double slope = this.maxConcurr / (double)this.rampUp;
        return Math.round(slope * timeOffset);
    }

    void checkNeedsPropertiesReloading(long now) {
        if (CACHING_VALIDITY_MS > 0L && now - this.lastCachedTime > CACHING_VALIDITY_MS) {
            this.rampUp = this.owner.getRampUpSeconds();
            this.hold = this.owner.getHoldSeconds();
            this.steps = this.owner.getStepsAsLong();
            this.maxConcurr = this.owner.getTargetLevelAsDouble();
            this.defaultShiftRampup = JMeterUtils.getPropDefault("dynamic_tg.shift_rampup_start", 0L);
            this.lastCachedTime = System.currentTimeMillis();
        }
    }

    long getLastCachedTime() {
        return this.lastCachedTime;
    }
}

