/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import kg.apc.charting.AbstractGraphPanelChartElement;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.charting.DateTimeRenderer;
import kg.apc.charting.DividerRenderer;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.NumberRenderer;

public class GraphModelToCsvExporter {
    private AbstractMap<String, AbstractGraphRow> model = null;
    private File destFile = null;
    private String csvSeparator;
    private char decimalSeparator;
    private SimpleDateFormat dateFormatter = null;
    private String xAxisLabel;
    private NumberRenderer xAxisRenderer = null;
    private int hideNonRepValLimit = -1;

    public GraphModelToCsvExporter(AbstractMap<String, AbstractGraphRow> rows, File destFile, String csvSeparator, String xAxisLabel, NumberRenderer xAxisRenderer, int hideNonRepValLimit) {
        this.destFile = destFile;
        this.model = rows;
        this.csvSeparator = csvSeparator;
        this.decimalSeparator = new DecimalFormatSymbols().getDecimalSeparator();
        this.xAxisLabel = xAxisLabel;
        this.hideNonRepValLimit = hideNonRepValLimit;
        if (xAxisRenderer != null && xAxisRenderer instanceof DividerRenderer) {
            this.xAxisRenderer = new DividerRenderer(((DividerRenderer)xAxisRenderer).getFactor());
        } else if (xAxisRenderer != null && xAxisRenderer instanceof DateTimeRenderer) {
            String format = JMeterUtils.getPropDefault("jmeterPlugin.csvTimeFormat", "HH:mm:ss" + this.decimalSeparator + "S");
            this.dateFormatter = new SimpleDateFormat(format);
        }
    }

    public GraphModelToCsvExporter(AbstractMap<String, AbstractGraphRow> rows, File destFile, String csvSeparator, char decimalSeparator, NumberRenderer renderer, int hideNonRepValLimit) {
        this(rows, destFile, csvSeparator, "Elapsed time", renderer, hideNonRepValLimit);
        this.decimalSeparator = decimalSeparator;
        this.dateFormatter = new SimpleDateFormat("HH:mm:ss" + decimalSeparator + "S");
    }

    private String xValueFormatter(long xValue) {
        String ret;
        if (this.xAxisRenderer != null) {
            this.xAxisRenderer.setValue(xValue);
            ret = this.xAxisRenderer.getText();
        } else {
            ret = this.dateFormatter != null ? this.dateFormatter.format(xValue) : "" + xValue;
        }
        return ret;
    }

    public void writeCsvFile() throws IOException {
        ConcurrentSkipListSet<Long> xValues = new ConcurrentSkipListSet<Long>();
        Iterator<Map.Entry<String, AbstractGraphRow>> it = this.model.entrySet().iterator();
        ArrayList<String> rawsName = new ArrayList<String>();
        while (it.hasNext()) {
            Map.Entry<String, AbstractGraphRow> row = it.next();
            rawsName.add(row.getKey());
            Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> itRow = row.getValue().iterator();
            while (itRow.hasNext()) {
                Map.Entry<Long, AbstractGraphPanelChartElement> element = itRow.next();
                if (!element.getValue().isPointRepresentative(this.hideNonRepValLimit)) continue;
                xValues.add(element.getKey());
            }
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.destFile));
        writer.write(this.xAxisLabel);
        for (int i = 0; i < rawsName.size(); ++i) {
            writer.write(this.csvSeparator);
            writer.write((String)rawsName.get(i));
        }
        writer.newLine();
        writer.flush();
        Iterator itXValues = xValues.iterator();
        while (itXValues.hasNext()) {
            long xValue = (Long)itXValues.next();
            writer.write(this.xValueFormatter(xValue));
            for (int i = 0; i < rawsName.size(); ++i) {
                writer.write(this.csvSeparator);
                AbstractGraphRow row = this.model.get(rawsName.get(i));
                AbstractGraphPanelChartElement value = row.getElement(xValue);
                if (value == null) continue;
                writer.write("" + value.getValue());
            }
            writer.newLine();
            writer.flush();
        }
        writer.close();
    }
}

