/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting.plotters;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import kg.apc.charting.AbstractGraphPanelChartElement;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.charting.ChartSettings;
import org.apache.jorphan.gui.NumberRenderer;

public abstract class AbstractRowPlotter
implements Serializable {
    private static final int labelSpacing = 5;
    private Stroke lineStroke = null;
    protected ChartSettings chartSettings = null;
    protected NumberRenderer labelRenderer = null;
    protected Rectangle chartRect = null;
    protected long minXVal;
    protected long maxXVal;
    protected double minYVal;
    protected double maxYVal;
    protected double dxForDVal;
    protected double dyForDVal;
    protected double calcPointX = 0.0;
    protected double calcPointY = 0.0;
    protected int x;
    protected int y;
    protected int prevX;
    protected int prevY;
    protected boolean allowMarkers = false;
    protected boolean mustDrawFirstZeroingLine;

    public AbstractRowPlotter(ChartSettings chartSettings, NumberRenderer labelRenderer) {
        this.chartSettings = chartSettings;
        this.labelRenderer = labelRenderer;
    }

    public void setBoundsValues(Rectangle chartRect, long minXVal, long maxXVal, double minYVal, double maxYVal) {
        this.chartRect = chartRect;
        this.minXVal = minXVal;
        this.maxXVal = maxXVal;
        this.minYVal = minYVal;
        this.maxYVal = maxYVal;
        this.dxForDVal = maxXVal <= minXVal ? 0.0 : (double)chartRect.width / (double)(maxXVal - minXVal);
        this.dyForDVal = maxYVal <= minYVal ? 0.0 : (double)chartRect.height / (maxYVal - minYVal);
    }

    protected boolean isChartPointValid(int xx, int yy) {
        boolean ret = true;
        if (xx < this.chartRect.x || xx > this.chartRect.x + this.chartRect.width) {
            ret = false;
        } else if (yy > this.chartRect.y + this.chartRect.height) {
            ret = false;
        }
        return ret;
    }

    public synchronized void paintRow(Graphics2D g2d, AbstractGraphRow row, Color color, double zoomFactor, int limitPointFactor) {
        Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> it = row.iterator();
        this.prevX = -1;
        this.prevY = this.chartRect.y + this.chartRect.height;
        this.mustDrawFirstZeroingLine = this.chartSettings.isDrawFinalZeroingLines();
        Stroke olStroke = g2d.getStroke();
        if (row.isDrawThickLines()) {
            g2d.setStroke(this.chartSettings.getThickStroke());
        } else {
            g2d.setStroke(this.getLineStroke());
        }
        g2d.setColor(color);
        while (it.hasNext()) {
            Map.Entry<Long, AbstractGraphPanelChartElement> element;
            if (!row.isDrawOnChart()) continue;
            if (limitPointFactor == 1) {
                element = it.next();
                AbstractGraphPanelChartElement elt = element.getValue();
                if (this.chartSettings.getHideNonRepValLimit() > 0) {
                    while (!elt.isPointRepresentative(this.chartSettings.getHideNonRepValLimit()) && it.hasNext()) {
                        element = it.next();
                        elt = element.getValue();
                    }
                    if (!elt.isPointRepresentative(this.chartSettings.getHideNonRepValLimit())) break;
                }
                this.calcPointX = element.getKey().doubleValue();
                this.calcPointY = elt.getValue();
            } else {
                this.calcPointX = 0.0;
                this.calcPointY = 0.0;
                int nbPointProcessed = 0;
                for (int i = 0; i < limitPointFactor; ++i) {
                    if (!it.hasNext()) continue;
                    element = it.next();
                    this.calcPointX += element.getKey().doubleValue();
                    this.calcPointY += element.getValue().getValue();
                    ++nbPointProcessed;
                }
                this.calcPointX /= (double)nbPointProcessed;
                this.calcPointY /= (double)nbPointProcessed;
            }
            this.calcPointY *= zoomFactor;
            this.x = this.chartRect.x + (int)((this.calcPointX - (double)this.minXVal) * this.dxForDVal);
            int yHeight = (int)((this.calcPointY - this.minYVal) * this.dyForDVal);
            this.y = this.chartRect.y + this.chartRect.height - yHeight;
            this.processPoint(g2d, row.getGranulationValue());
            if (this.isChartPointValid(this.x, this.y)) {
                if (this.allowMarkers) {
                    this.processMarker(g2d, row);
                }
                this.prevX = this.x;
                this.prevY = this.y;
            }
            if (!row.isDrawValueLabel() || !this.isChartPointValid(this.x, this.y) || this.y < this.chartRect.y) continue;
            this.drawLabels(g2d, row, this.calcPointY);
        }
        this.processFinalLines(row, g2d);
        this.x = 0;
        this.y = 0;
        this.prevX = -1;
        this.prevY = this.chartRect.y + this.chartRect.height;
        this.postPaintRow(row, g2d);
        g2d.setStroke(olStroke);
    }

    protected abstract void processPoint(Graphics2D var1, int var2);

    protected void postPaintRow(AbstractGraphRow row, Graphics2D g2d) {
    }

    private void processMarker(Graphics2D g2d, AbstractGraphRow row) {
        int radius = row.getMarkerSize();
        if (this.chartSettings.getChartMarkers() == 1) {
            radius = Math.max(2, row.getMarkerSize());
        }
        if (this.chartSettings.getChartMarkers() == 2) {
            radius = 0;
        }
        if (radius != 0 && this.y >= this.chartRect.y && this.isChartPointValid(this.x, this.y)) {
            g2d.fillOval(this.x - radius, this.y - radius, radius * 2, radius * 2);
        }
    }

    private void drawLabels(Graphics2D g2d, AbstractGraphRow row, double yValue) {
        Color oldColor = g2d.getColor();
        g2d.setColor(Color.DARK_GRAY);
        Font oldFont = g2d.getFont();
        g2d.setFont(g2d.getFont().deriveFont(1));
        FontMetrics fm = g2d.getFontMetrics(g2d.getFont());
        this.labelRenderer.setValue(yValue);
        int labelSize = g2d.getFontMetrics(g2d.getFont()).stringWidth(this.labelRenderer.getText());
        if (this.x + row.getMarkerSize() + 5 + labelSize > this.chartRect.x + this.chartRect.width) {
            g2d.drawString(this.labelRenderer.getText(), this.x - row.getMarkerSize() - 5 - labelSize, this.y + fm.getAscent() / 2);
        } else {
            g2d.drawString(this.labelRenderer.getText(), this.x + row.getMarkerSize() + 5, this.y + fm.getAscent() / 2);
        }
        g2d.setFont(oldFont);
        g2d.setColor(oldColor);
    }

    private void processFinalLines(AbstractGraphRow row, Graphics2D g2d) {
        if (this.chartSettings.getLineWidth() == 0.0f) {
            return;
        }
        Stroke oldStroke = null;
        if (row.isDrawLine() && this.chartSettings.isDrawFinalZeroingLines()) {
            if (row.isDrawThickLines()) {
                oldStroke = g2d.getStroke();
                g2d.setStroke(this.chartSettings.getThickStroke());
            }
            g2d.drawLine(this.prevX, Math.max(this.prevY, this.chartRect.y), (int)((double)this.prevX + this.dxForDVal), this.chartRect.y + this.chartRect.height);
            if (row.isDrawThickLines()) {
                g2d.setStroke(oldStroke);
            }
        }
    }

    private Stroke getLineStroke() {
        this.lineStroke = this.chartSettings.getLineWidth() > 1.0f ? new BasicStroke(this.chartSettings.getLineWidth(), 1, 1) : new BasicStroke(this.chartSettings.getLineWidth());
        return this.lineStroke;
    }
}

