/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.MatteBorder;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class JMeterPluginsUtils {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String PLUGINS_PREFIX = "jp@gc - ";
    private static boolean prefixPlugins = true;
    public static final String WIKI_BASE = "http://jmeter-plugins.org/wiki/";
    private static String version = null;
    public static final String ENCODING = JMeterUtils.getPropDefault("sampleresult.default.encoding", "ISO-8859-1");
    public static final Charset CHARSET = Charset.forName(ENCODING);

    public static String prefixLabel(String label) {
        return prefixPlugins ? PLUGINS_PREFIX + label : label;
    }

    public static String getStackTrace(Exception ex) {
        StackTraceElement[] stack = ex.getStackTrace();
        StringBuilder res = new StringBuilder();
        for (StackTraceElement aStack : stack) {
            res.append("at ");
            res.append(aStack.toString());
            res.append("\n");
        }
        return res.toString();
    }

    public static CollectionProperty tableModelRowsToCollectionProperty(PowerTableModel model, String propname) {
        CollectionProperty rows = new CollectionProperty(propname, new ArrayList());
        for (int row = 0; row < model.getRowCount(); ++row) {
            List<Object> item = JMeterPluginsUtils.getArrayListForArray(model.getRowData(row));
            rows.addItem(item);
        }
        return rows;
    }

    public static CollectionProperty tableModelRowsToCollectionPropertyEval(PowerTableModel model, String propname) {
        CollectionProperty rows = new CollectionProperty(propname, new ArrayList());
        for (int row = 0; row < model.getRowCount(); ++row) {
            List<Object> item = JMeterPluginsUtils.getArrayListForArrayEval(model.getRowData(row));
            rows.addItem(item);
        }
        return rows;
    }

    public static void collectionPropertyToTableModelRows(CollectionProperty prop, PowerTableModel model) {
        model.clearData();
        for (int rowN = 0; rowN < prop.size(); ++rowN) {
            ArrayList rowObject = (ArrayList)prop.get(rowN).getObjectValue();
            model.addRow(rowObject.toArray());
        }
        model.fireTableDataChanged();
    }

    public static void collectionPropertyToTableModelRows(CollectionProperty prop, PowerTableModel model, Class[] columnClasses) {
        model.clearData();
        for (int rowN = 0; rowN < prop.size(); ++rowN) {
            int i;
            ArrayList rowStrings = (ArrayList)prop.get(rowN).getObjectValue();
            ArrayList<Object> rowObject = new ArrayList<Object>(rowStrings.size());
            for (i = 0; i < columnClasses.length && i < rowStrings.size(); ++i) {
                rowObject.add(JMeterPluginsUtils.convertToClass((StringProperty)rowStrings.get(i), columnClasses[i]));
            }
            if (rowObject.size() < columnClasses.length) {
                for (i = rowObject.size(); i < columnClasses.length; ++i) {
                    rowObject.add(new Object());
                }
            }
            model.addRow(rowObject.toArray());
        }
        model.fireTableDataChanged();
    }

    private static List<Object> getArrayListForArray(Object[] rowData) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Object aRowData : rowData) {
            res.add(aRowData);
        }
        return res;
    }

    private static List<Object> getArrayListForArrayEval(Object[] rowData) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Object aRowData : rowData) {
            res.add(new CompoundVariable(aRowData.toString()).execute());
        }
        return res;
    }

    public static String replaceRNT(String str) {
        str = str.replaceAll("\\\\\\\\", "VERY BAD WAY");
        str = str.replaceAll("\\\\t", "\t");
        str = str.replaceAll("\\\\n", "\n");
        str = str.replaceAll("\\\\r", "\r");
        str = str.replaceAll("VERY BAD WAY", "\\\\");
        return str;
    }

    public static String getWikiLinkText(String wikiPage) {
        if (!Desktop.isDesktopSupported()) {
            return "Plugin help available here: http://jmeter-plugins.org/wiki/" + wikiPage;
        }
        return "";
    }

    private static Object convertToClass(StringProperty value, Class aClass) {
        if (Boolean.class.equals((Object)aClass)) {
            return Boolean.valueOf(value.getStringValue());
        }
        return value;
    }

    public static String buildHelpPageUrl(String helpPage) {
        try {
            if (helpPage.matches("[hH][tT][tT][pP][sS]?://.*")) {
                log.debug("Help page URL found, skipping building link to http://jmeter-plugins.org/wiki/");
                return helpPage;
            }
        }
        catch (PatternSyntaxException ex) {
            log.warn("Invalid regex", ex);
        }
        if (helpPage.endsWith("Gui")) {
            helpPage = helpPage.substring(0, helpPage.length() - 3);
        }
        return WIKI_BASE + helpPage + "/?utm_source=jmeter&utm_medium=helplink&utm_campaign=" + helpPage;
    }

    public static Component addHelpLinkToPanel(Container panel, String helpPage) {
        if (!Desktop.isDesktopSupported()) {
            return panel;
        }
        JLabel icon = new JLabel();
        icon.setIcon(new ImageIcon(JMeterPluginsUtils.class.getResource("vizualizers/information.png")));
        JLabel link = new JLabel("Help on this plugin");
        link.setForeground(Color.blue);
        link.setFont(link.getFont().deriveFont(0));
        link.setCursor(new Cursor(12));
        link.addMouseListener(new URIOpener(JMeterPluginsUtils.buildHelpPageUrl(helpPage)));
        MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.blue);
        link.setBorder(border);
        JLabel version = new JLabel("");
        version.setFont(version.getFont().deriveFont(0).deriveFont(11.0f));
        version.setForeground(Color.GRAY);
        Container innerPanel = JMeterPluginsUtils.findComponentWithBorder((JComponent)panel, EtchedBorder.class);
        JPanel panelLink = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        panelLink.add((Component)icon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 3, 0);
        panelLink.add((Component)link, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        panelLink.add((Component)version, gridBagConstraints);
        if (innerPanel != null) {
            innerPanel.add(panelLink);
        } else {
            panel.add(panelLink);
        }
        return panel;
    }

    private static Container findComponentWithBorder(JComponent panel, Class<?> aClass) {
        for (int n = 0; n < panel.getComponentCount(); ++n) {
            if (!(panel.getComponent(n) instanceof JComponent)) continue;
            JComponent comp = (JComponent)panel.getComponent(n);
            if (comp.getBorder() != null && aClass.isAssignableFrom(comp.getBorder().getClass())) {
                return comp;
            }
            Container con = JMeterPluginsUtils.findComponentWithBorder(comp, aClass);
            if (con == null) continue;
            return con;
        }
        return null;
    }

    public static void doBestCSVSetup(SampleSaveConfiguration conf) {
        conf.setAsXml(false);
        conf.setFieldNames(true);
        conf.setSamplerData(false);
        conf.setRequestHeaders(false);
        conf.setFileName(false);
        conf.setIdleTime(false);
        conf.setSuccess(true);
        conf.setMessage(true);
        conf.setEncoding(false);
        conf.setThreadCounts(true);
        conf.setFieldNames(true);
        conf.setAssertions(false);
        conf.setResponseData(false);
        conf.setSubresults(false);
        conf.setLatency(true);
        conf.setLabel(true);
        conf.setThreadName(true);
        conf.setBytes(true);
        conf.setHostname(true);
        conf.setAssertionResultsFailureMessage(false);
        conf.setResponseHeaders(false);
        conf.setUrl(false);
        conf.setTime(true);
        conf.setTimestamp(true);
        conf.setCode(true);
        conf.setDataType(false);
        conf.setSampleCount(false);
    }

    public static void openInBrowser(String string) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(string));
            }
            catch (IOException | URISyntaxException ignored) {
                log.debug("Failed to open in browser", ignored);
            }
        }
    }

    public static float getFloatFromString(String stringValue, float defaultValue) {
        float ret;
        if (stringValue != null) {
            try {
                ret = Float.valueOf(stringValue).floatValue();
            }
            catch (NumberFormatException ex) {
                ret = defaultValue;
            }
        } else {
            ret = defaultValue;
        }
        return ret;
    }

    public static int getSecondsForShortString(String string) {
        int res = 0;
        string = string.trim();
        String curNum = "";
        for (int n = 0; n < string.length(); ++n) {
            int mul;
            String c = String.valueOf(string.charAt(n));
            if (c.matches("\\d")) {
                curNum = curNum + c;
                continue;
            }
            switch (c.charAt(0)) {
                case 'S': 
                case 's': {
                    mul = 1;
                    break;
                }
                case 'M': 
                case 'm': {
                    mul = 60;
                    break;
                }
                case 'H': 
                case 'h': {
                    mul = 3600;
                    break;
                }
                case 'D': 
                case 'd': {
                    mul = 86400;
                    break;
                }
                default: {
                    throw new NumberFormatException("Shorthand string does not allow using '" + c + "'");
                }
            }
            res += Integer.parseInt(curNum) * mul;
            curNum = "";
        }
        if (!curNum.isEmpty()) {
            res += Integer.parseInt(curNum);
        }
        return res;
    }

    public static String getVersion() {
        if (version == null) {
            Properties props = new Properties();
            try {
                throw new IOException("Deprecated call");
            }
            catch (IOException ex) {
                props.setProperty("version", "N/A");
                version = props.getProperty("version");
            }
        }
        return version;
    }

    public static String getEnvDefault(String propName, String defaultVal) {
        String ans = defaultVal;
        String value = System.getenv(propName);
        if (value != null) {
            ans = value.trim();
        } else if (defaultVal != null) {
            ans = defaultVal.trim();
        }
        return ans;
    }

    public static void prepareJMeterEnv(String homeDir) {
        if (JMeterUtils.getJMeterHome() != null) {
            log.warn("JMeter env exists. No one should see this normally.");
            return;
        }
        log.debug("Orig jmeter home dir: " + homeDir);
        File dir = new File(homeDir);
        while (dir.exists() && dir.getName().equals("ext") && dir.getParentFile().getName().equals("lib")) {
            dir = dir.getParentFile();
        }
        if (!dir.exists()) {
            throw new IllegalArgumentException("CMDRunner.jar must be placed in <jmeter>/lib/ext directory");
        }
        homeDir = dir.getParent();
        if (!JMeterPluginsUtils.isJMeterHome(homeDir)) {
            homeDir = JMeterPluginsUtils.getJMeterHomeFromCP(System.getProperty("java.class.path"));
        }
        log.debug("Final jmeter home dir: " + homeDir);
        JMeterUtils.setJMeterHome(homeDir);
        JMeterPluginsUtils.initializeProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeProperties() {
        String sysProp;
        JMeterUtils.loadJMeterProperties(JMeterUtils.getJMeterHome() + File.separator + "bin" + File.separator + "jmeter.properties");
        JMeterUtils.initLocale();
        Properties jmeterProps = JMeterUtils.getJMeterProperties();
        String userProp = JMeterUtils.getPropDefault("user.properties", "");
        if (userProp.length() > 0) {
            FileInputStream fis = null;
            try {
                File file = JMeterUtils.findFile(userProp);
                if (file.canRead()) {
                    log.info("Loading user properties from: " + file.getCanonicalPath());
                    fis = new FileInputStream(file);
                    Properties tmp = new Properties();
                    tmp.load(fis);
                    jmeterProps.putAll((Map<?, ?>)tmp);
                    LoggingManager.setLoggingLevels(jmeterProps);
                }
            }
            catch (IOException e) {
                log.warn("Error loading user property file: " + userProp, e);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    log.warn("There was problem closing file stream", ex);
                }
            }
        }
        if ((sysProp = JMeterUtils.getPropDefault("system.properties", "")).length() > 0) {
            FileInputStream fis = null;
            try {
                File file = JMeterUtils.findFile(sysProp);
                if (file.canRead()) {
                    log.info("Loading system properties from: " + file.getCanonicalPath());
                    fis = new FileInputStream(file);
                    System.getProperties().load(fis);
                }
            }
            catch (IOException e) {
                log.warn("Error loading system property file: " + sysProp, e);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    log.warn("There was problem closing file stream", ex);
                }
            }
        }
    }

    private static boolean isJMeterHome(String homeDir) {
        File f = new File(homeDir + File.separator + "lib" + File.separator + "ext");
        return f.exists() && f.isDirectory();
    }

    public static String getJMeterHomeFromCP(String classpathSTR) {
        String[] paths;
        log.debug("Trying to get JMeter home from classpath");
        String splitter = classpathSTR.indexOf(59) != -1 ? ";" : ":";
        for (String string : paths = classpathSTR.split(splitter)) {
            log.debug("Testing " + string);
            if (!string.endsWith("ApacheJMeter_core.jar")) continue;
            File f = new File(string);
            return f.getParentFile().getParentFile().getParentFile().getAbsolutePath();
        }
        throw new Error("Failed to find JMeter home dir from classpath");
    }

    public static String getShortHostname(String host) {
        log.debug("getShortHostname: " + host);
        try {
            String defaultRegex = "([\\w\\-]+)\\..*";
            String hostnameRegex = JMeterUtils.getPropDefault("jmeterPlugin.perfmon.label.useHostname.pattern", defaultRegex);
            log.debug("hostnameRegex: " + hostnameRegex);
            Pattern p = Pattern.compile(hostnameRegex, 2);
            Matcher m = p.matcher(host);
            if (m.matches()) {
                String shortName = m.group(1);
                log.debug("shortName of " + host + " is: " + shortName);
                host = shortName;
            }
        }
        catch (Exception e) {
            log.warn("getShortHostname exception: " + e.getClass().getName() + " :: " + e.getMessage());
            log.debug("getShortHostname exception: ", e);
        }
        return host;
    }

    static {
        JMeterPluginsUtils.getVersion();
        String prefixPluginsCfg = JMeterUtils.getProperty("jmeterPlugin.prefixPlugins");
        if (prefixPluginsCfg != null) {
            prefixPlugins = "true".equalsIgnoreCase(prefixPluginsCfg.trim());
        }
    }

    private static class URIOpener
    extends MouseAdapter {
        private final String uri;

        public URIOpener(String aURI) {
            this.uri = aURI;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 0x10) == 16) {
                JMeterPluginsUtils.openInBrowser(this.uri);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

