/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.dummy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.dummy.DummyElement;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import kg.apc.jmeter.modifiers.DummySubPostProcessor;
import kg.apc.jmeter.samplers.DummySampler;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.reflect.ClassFinder;

public class DummyPanel
extends JPanel {
    private JCheckBox isSuccessful;
    private JTextField responseCode;
    private JTextField responseMessage;
    private JTextField responseTime;
    private JTextArea responseData;
    private JTextArea requestData;
    private JCheckBox isWaiting;
    private JTextField latency;
    private JTextField connect;
    private JTextField url;
    private JComboBox<String> resultClass;

    public DummyPanel() {
        super(new GridBagLayout());
    }

    public void configure(TestElement element) {
        this.isSuccessful.setSelected(element.getPropertyAsBoolean("SUCCESFULL"));
        this.isWaiting.setSelected(element.getPropertyAsBoolean("WAITING"));
        this.responseCode.setText(element.getPropertyAsString("RESPONSE_CODE"));
        this.responseMessage.setText(element.getPropertyAsString("RESPONSE_MESSAGE"));
        this.requestData.setText(element.getPropertyAsString("REQUEST_DATA"));
        this.responseData.setText(element.getPropertyAsString("RESPONSE_DATA"));
        this.responseTime.setText(element.getPropertyAsString("RESPONSE_TIME"));
        this.latency.setText(element.getPropertyAsString("LATENCY"));
        this.connect.setText(element.getPropertyAsString("CONNECT"));
        this.url.setText(element.getPropertyAsString("URL"));
        this.resultClass.setSelectedItem(element.getPropertyAsString("RESULT_CLASS"));
    }

    public void modifyTestElement(TestElement te) {
        DummyElement dummy;
        if (te instanceof DummySampler) {
            dummy = ((DummySampler)te).getDummy();
        } else if (te instanceof DummySubPostProcessor) {
            dummy = ((DummySubPostProcessor)te).getDummy();
        } else {
            return;
        }
        dummy.setSimulateWaiting(this.isWaiting.isSelected());
        dummy.setSuccessful(this.isSuccessful.isSelected());
        dummy.setResponseCode(this.responseCode.getText());
        dummy.setResponseMessage(this.responseMessage.getText());
        dummy.setRequestData(this.requestData.getText());
        dummy.setResponseData(this.responseData.getText());
        dummy.setResponseTime(this.responseTime.getText());
        dummy.setLatency(this.latency.getText());
        dummy.setConnectTime(this.connect.getText());
        dummy.setURL(this.url.getText());
        dummy.setResultClass(Objects.requireNonNull(this.resultClass.getSelectedItem()).toString());
    }

    public void initFields() {
        this.isSuccessful.setSelected(true);
        this.isWaiting.setSelected(true);
        this.responseCode.setText("200");
        this.responseMessage.setText("OK");
        this.requestData.setText("Dummy Sampler used to simulate requests and responses\nwithout actual network activity. This helps debugging tests.");
        this.responseData.setText("Dummy Sampler used to simulate requests and responses\nwithout actual network activity. This helps debugging tests.");
        this.responseTime.setText("${__Random(50,500)}");
        this.latency.setText("${__Random(1,50)}");
        this.connect.setText("${__Random(1,5)}");
        this.url.setText("");
        this.resultClass.setSelectedItem(SampleResult.class.getCanonicalName());
    }

    public JPanel init() {
        String[] classesThatExtend;
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 24;
        GridBagConstraints editConstraints = new GridBagConstraints();
        editConstraints.anchor = 23;
        editConstraints.weightx = 1.0;
        editConstraints.fill = 2;
        this.addToPanel(this, labelConstraints, 0, 0, new JLabel("Successful sample: ", 4));
        this.isSuccessful = new JCheckBox();
        this.addToPanel(this, editConstraints, 1, 0, this.isSuccessful);
        this.addToPanel(this, labelConstraints, 0, 1, new JLabel("Response Code (eg 200): ", 4));
        this.responseCode = new JTextField(20);
        this.addToPanel(this, editConstraints, 1, 1, this.responseCode);
        editConstraints.insets = new Insets(2, 0, 0, 0);
        labelConstraints.insets = new Insets(2, 0, 0, 0);
        this.addToPanel(this, labelConstraints, 0, 2, new JLabel("Response Message (eg OK): ", 4));
        this.responseMessage = new JTextField(20);
        this.addToPanel(this, editConstraints, 1, 2, this.responseMessage);
        this.addToPanel(this, labelConstraints, 0, 3, new JLabel("Connect Time (milliseconds): ", 4));
        this.connect = new JTextField(20);
        this.addToPanel(this, editConstraints, 1, 3, this.connect);
        this.addToPanel(this, labelConstraints, 0, 4, new JLabel("Latency (milliseconds): ", 4));
        this.latency = new JTextField(20);
        this.addToPanel(this, editConstraints, 1, 4, this.latency);
        this.addToPanel(this, labelConstraints, 0, 5, new JLabel("Response Time (milliseconds): ", 4));
        this.responseTime = new JTextField(20);
        this.addToPanel(this, editConstraints, 1, 5, this.responseTime);
        this.addToPanel(this, labelConstraints, 0, 6, new JLabel("Simulate Response Time (sleep): ", 4));
        this.isWaiting = new JCheckBox();
        this.addToPanel(this, editConstraints, 1, 6, this.isWaiting);
        editConstraints.insets = new Insets(4, 0, 0, 0);
        labelConstraints.insets = new Insets(4, 0, 0, 0);
        this.addToPanel(this, labelConstraints, 0, 7, new JLabel("Request Data: ", 4));
        editConstraints.fill = 1;
        this.requestData = new JTextArea();
        this.addToPanel(this, editConstraints, 1, 7, GuiBuilderHelper.getTextAreaScrollPaneContainer(this.requestData, 10));
        this.addToPanel(this, labelConstraints, 0, 8, new JLabel("Response Data: ", 4));
        editConstraints.fill = 1;
        this.responseData = new JTextArea();
        this.addToPanel(this, editConstraints, 1, 8, GuiBuilderHelper.getTextAreaScrollPaneContainer(this.responseData, 10));
        this.addToPanel(this, labelConstraints, 0, 9, new JLabel("URL: ", 4));
        this.url = new JTextField();
        this.addToPanel(this, editConstraints, 1, 9, this.url);
        try {
            String[] paths = JMeterUtils.getSearchPaths();
            Class[] lookup = new Class[]{SampleResult.class};
            classesThatExtend = ClassFinder.findClassesThatExtend(paths, lookup).toArray(new String[0]);
            if (classesThatExtend.length < 1) {
                throw new IOException("Go to default");
            }
        }
        catch (IOException e) {
            classesThatExtend = new String[]{SampleResult.class.getCanonicalName()};
        }
        this.resultClass = new JComboBox<String>(classesThatExtend);
        this.addToPanel(this, labelConstraints, 0, 10, new JLabel("SampleResult class: ", 4));
        this.addToPanel(this, editConstraints, 1, 10, this.resultClass);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)this, "North");
        return container;
    }

    private void addToPanel(JPanel panel, GridBagConstraints constraints, int col, int row, JComponent component) {
        constraints.gridx = col;
        constraints.gridy = row;
        panel.add((Component)component, constraints);
    }
}

