/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.graphs;

import kg.apc.charting.DateTimeRenderer;
import kg.apc.jmeter.graphs.AbstractGraphPanelVisualizer;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.threads.JMeterContextService;

public abstract class AbstractOverTimeVisualizer
extends AbstractGraphPanelVisualizer {
    protected long relativeStartTime = 0L;
    private boolean isJtlLoad = false;

    public AbstractOverTimeVisualizer() {
        this.graphPanel.getGraphObject().setxAxisLabelRenderer(new DateTimeRenderer("HH:mm:ss"));
        this.graphPanel.getGraphObject().setxAxisLabel("Elapsed time");
        this.graphPanel.getGraphObject().setDisplayPrecision(true);
    }

    @Override
    public void add(SampleResult sample) {
        if (this.relativeStartTime == 0L) {
            if (!this.isIgnoreCurrentTestStartTime()) {
                this.relativeStartTime = JMeterContextService.getTestStartTime();
            }
            this.isJtlLoad = false;
            if (this.relativeStartTime == 0L) {
                this.relativeStartTime = sample.getStartTime();
                this.isJtlLoad = true;
            }
            this.relativeStartTime -= this.relativeStartTime % (long)this.getGranulation();
            this.handleRelativeStartTime();
        }
        if (this.isJtlLoad && this.relativeStartTime > sample.getStartTime()) {
            this.relativeStartTime = sample.getStartTime() - sample.getStartTime() % (long)this.getGranulation();
            this.handleRelativeStartTime();
        }
    }

    protected void handleRelativeStartTime() {
        if (this.graphPanel.getGraphObject().getChartSettings().isUseRelativeTime()) {
            this.graphPanel.getGraphObject().setxAxisLabelRenderer(new DateTimeRenderer("HH:mm:ss", this.relativeStartTime));
        }
        this.graphPanel.getGraphObject().setTestStartTime(this.relativeStartTime);
        this.graphPanel.getGraphObject().setForcedMinX(this.relativeStartTime);
    }

    @Override
    public void clearData() {
        super.clearData();
        this.relativeStartTime = 0L;
        this.isJtlLoad = false;
        this.updateGui();
    }

    protected long normalizeTime(long time) {
        return time - time % (long)this.getGranulation();
    }
}

