/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.graphs;

import java.awt.Color;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.graphs.ColorRenderer;
import kg.apc.jmeter.graphs.HeaderAsTextRenderer;
import kg.apc.jmeter.graphs.HeaderClickCheckAllListener;
import kg.apc.jmeter.graphs.JRowsSelectorPanel;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.reflect.Functor;

class ChartRowsTable
extends JTable {
    TableCellRenderer colorRenderer = new ColorRenderer(false);
    JRowsSelectorPanel parentContainer = null;

    public ChartRowsTable(JRowsSelectorPanel parent) {
        this.parentContainer = parent;
        this.initializeTableModel();
        this.setSelectionMode(0);
        this.getTableHeader().setDefaultRenderer(new HeaderAsTextRenderer());
        this.getTableHeader().addMouseListener(new HeaderClickCheckAllListener());
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
        this.setCollumnsSize();
    }

    private void setCollumnsSize() {
        this.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.getColumnModel().getColumn(2).setPreferredWidth(500);
    }

    private void initializeTableModel() {
        ObjectTableModel model = new ObjectTableModel(new String[]{"(Un)Check All", "Legend Color", "Row Name"}, AbstractGraphRow.class, new Functor[]{new Functor("isDrawOnChart"), new Functor("getColor"), new Functor("getLabel")}, new Functor[]{new Functor("setDrawOnChart"), null, null}, new Class[]{Boolean.class, Color.class, String.class});
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (ChartRowsTable.this.parentContainer != null) {
                    ChartRowsTable.this.parentContainer.refreshPreview();
                }
            }
        });
        this.setModel(model);
    }

    public void addRow(AbstractGraphRow row) {
        ((ObjectTableModel)this.dataModel).addRow(row);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 1) {
            return this.colorRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    public void clear() {
        this.initializeTableModel();
        this.setCollumnsSize();
    }
}

