/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.timers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.charting.DateTimeRenderer;
import kg.apc.charting.GraphPanelChart;
import kg.apc.charting.rows.GraphRowExactValues;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.gui.ButtonPanelAddCopyRemove;
import kg.apc.jmeter.gui.GuiBuilderHelper;
import kg.apc.jmeter.timers.VariableThroughputTimer;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.timers.gui.AbstractTimerGui;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class VariableThroughputTimerGui
extends AbstractTimerGui
implements TableModelListener,
CellEditorListener {
    public static final String WIKIPAGE = "ThroughputShapingTimer";
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected ConcurrentHashMap<String, AbstractGraphRow> model;
    protected GraphPanelChart chart;
    private static Integer[] defaultValues = new Integer[]{1, 1000, 60};
    protected PowerTableModel tableModel;
    protected JTable grid;
    protected ButtonPanelAddCopyRemove buttons;

    public VariableThroughputTimerGui() {
        this.init();
    }

    protected final void init() {
        this.setBorder(this.makeBorder());
        this.setLayout(new BorderLayout());
        this.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), WIKIPAGE), "North");
        VerticalPanel containerPanel = new VerticalPanel();
        containerPanel.add((Component)this.createParamsPanel(), "North");
        containerPanel.add((Component)GuiBuilderHelper.getComponentWithMargin(this.createChart(), 2, 2, 0, 2), "Center");
        this.add((Component)containerPanel, "Center");
    }

    private JPanel createParamsPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createTitledBorder("Requests Per Second (RPS) Schedule"));
        panel.setPreferredSize(new Dimension(200, 200));
        JScrollPane scroll = new JScrollPane(this.createGrid());
        scroll.setPreferredSize(scroll.getMinimumSize());
        panel.add((Component)scroll, "Center");
        this.buttons = new ButtonPanelAddCopyRemove(this.grid, this.tableModel, defaultValues);
        panel.add((Component)this.buttons, "South");
        return panel;
    }

    private JTable createGrid() {
        this.grid = new JTable();
        this.grid.getDefaultEditor(String.class).addCellEditorListener(this);
        this.createTableModel();
        this.grid.setSelectionMode(0);
        this.grid.setMinimumSize(new Dimension(200, 100));
        return this.grid;
    }

    @Override
    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Throughput Shaping Timer");
    }

    @Override
    public TestElement createTestElement() {
        VariableThroughputTimer tg = new VariableThroughputTimer();
        this.modifyTestElement(tg);
        tg.setComment(JMeterPluginsUtils.getWikiLinkText(WIKIPAGE));
        return tg;
    }

    @Override
    public void modifyTestElement(TestElement tg) {
        super.configureTestElement(tg);
        if (this.grid.isEditing()) {
            this.grid.getCellEditor().stopCellEditing();
        }
        if (tg instanceof VariableThroughputTimer) {
            VariableThroughputTimer utg = (VariableThroughputTimer)tg;
            CollectionProperty rows = JMeterPluginsUtils.tableModelRowsToCollectionProperty(this.tableModel, "load_profile");
            utg.setData(rows);
        }
    }

    @Override
    public void configure(TestElement tg) {
        super.configure(tg);
        VariableThroughputTimer utg = (VariableThroughputTimer)tg;
        JMeterProperty threadValues = utg.getData();
        if (threadValues instanceof NullProperty) {
            log.warn("Received null property instead of collection");
            return;
        }
        CollectionProperty columns = (CollectionProperty)threadValues;
        this.tableModel.removeTableModelListener(this);
        JMeterPluginsUtils.collectionPropertyToTableModelRows(columns, this.tableModel);
        this.tableModel.addTableModelListener(this);
        this.buttons.checkDeleteButtonStatus();
        this.updateUI();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tableModel != null) {
            VariableThroughputTimer utgForPreview = new VariableThroughputTimer();
            utgForPreview.setData(JMeterPluginsUtils.tableModelRowsToCollectionPropertyEval(this.tableModel, "load_profile"));
            this.updateChart(utgForPreview);
        }
    }

    private int getIntFromRow(int row, int col) {
        int ret;
        try {
            ret = Integer.valueOf(new CompoundVariable(this.tableModel.getValueAt(row, col).toString()).execute());
        }
        catch (NumberFormatException ex) {
            ret = -1;
        }
        return ret;
    }

    private void updateChart(VariableThroughputTimer tg) {
        this.model.clear();
        this.chart.clearErrorMessage();
        GraphRowExactValues row = new GraphRowExactValues();
        row.setColor(Color.BLUE);
        row.setDrawLine(true);
        row.setMarkerSize(0);
        row.setDrawThickLines(true);
        long now = System.currentTimeMillis();
        int rowsCount = this.tableModel.getRowCount();
        ((AbstractGraphRow)row).add(now, 0.0);
        ((AbstractGraphRow)row).add(now, tg.getRPSForSecond(0.0).getLeft());
        int duration = 0;
        for (int i = 0; i < rowsCount; ++i) {
            ((AbstractGraphRow)row).add(now + (long)((duration + 1) * 1000), tg.getRPSForSecond(duration + 1).getLeft());
            int rowVal = this.getIntFromRow(i, 2);
            if (rowVal < 0) {
                this.chart.setErrorMessage("The values entered cannot be rendered in preview...");
                break;
            }
            ((AbstractGraphRow)row).add(now + (long)((duration += rowVal) * 1000), tg.getRPSForSecond(duration).getLeft());
        }
        this.chart.setxAxisLabelRenderer(new DateTimeRenderer("HH:mm:ss", now - 1L));
        this.chart.setForcedMinX(now);
        this.model.put("Expected RPS", row);
        this.chart.invalidateCache();
        this.chart.repaint();
    }

    private Component createChart() {
        this.chart = new GraphPanelChart(false, true);
        this.model = new ConcurrentHashMap();
        this.chart.setRows(this.model);
        this.chart.getChartSettings().setDrawFinalZeroingLines(true);
        this.chart.setxAxisLabel("Elapsed Time");
        this.chart.setYAxisLabel("Number of requests /sec");
        this.chart.setBorder(BorderFactory.createBevelBorder(1));
        return this.chart;
    }

    private void createTableModel() {
        this.tableModel = new PowerTableModel(VariableThroughputTimer.columnIdentifiers, VariableThroughputTimer.columnClasses);
        this.tableModel.addTableModelListener(this);
        this.grid.setModel(this.tableModel);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        this.updateUI();
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.tableModel.clearData();
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateUI();
    }
}

