/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.vizualizers.CorrectedResultCollector;
import kg.apc.jmeter.vizualizers.MonitoringSampleGenerator;
import kg.apc.jmeter.vizualizers.MonitoringSampleResult;
import kg.apc.jmeter.vizualizers.MonitoringSampler;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class MonitoringResultsCollector
extends CorrectedResultCollector
implements Runnable,
MonitoringSampleGenerator {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String DATA_PROPERTY = "samplers";
    private int interval;
    private Thread workerThread;
    private volatile boolean stop = false;
    protected List<MonitoringSampler> samplers = new ArrayList<MonitoringSampler>();
    private String autoFileBaseName = null;
    private static int counter = 0;
    private String workerHost = null;
    private JMeterContext ctx;

    protected String getPrefix() {
        return "BaseMon";
    }

    protected String getForceFilePropertyName() {
        return "forceMonitoringFile";
    }

    protected boolean getAutoGenerateFiles() {
        return JMeterUtils.getPropDefault(this.getForceFilePropertyName(), "false").trim().equalsIgnoreCase("true");
    }

    private synchronized String getAutoFileName() {
        String ret = "";
        ++counter;
        if (this.autoFileBaseName == null) {
            Calendar now = Calendar.getInstance();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd-HHmmss");
            this.autoFileBaseName = this.getPrefix() + "_" + formatter.format(now.getTime());
        }
        ret = ret + this.autoFileBaseName;
        if (counter > 1) {
            ret = ret + "_" + counter;
        }
        ret = ret + ".csv";
        return ret;
    }

    protected int getInterval() {
        return 1000;
    }

    public MonitoringResultsCollector() {
        this.interval = this.getInterval();
    }

    public void setData(CollectionProperty rows) {
        this.setProperty(rows);
    }

    public CollectionProperty getSamplerSettings() {
        JMeterProperty prop = this.getProperty(DATA_PROPERTY);
        if (!(prop instanceof CollectionProperty)) {
            log.warn("Got unexpected property: " + prop);
            return new CollectionProperty();
        }
        CollectionProperty rows = (CollectionProperty)prop;
        return rows;
    }

    private void syncContext(boolean isInit) {
        JMeterContext current = JMeterContextService.getContext();
        JMeterContext ctx = this.getThreadContext();
        if (isInit) {
            current.setCurrentSampler(ctx.getCurrentSampler());
            current.setEngine(ctx.getEngine());
            current.setRestartNextLoop(ctx.isRestartNextLoop());
            current.setSamplingStarted(ctx.isSamplingStarted());
            current.setThread(ctx.getThread());
            current.setThreadGroup(ctx.getThreadGroup());
            current.setThreadNum(ctx.getThreadNum());
        }
        current.setVariables(ctx.getVariables());
        current.setPreviousResult(ctx.getPreviousResult());
    }

    @Override
    public synchronized void run() {
        try {
            this.syncContext(true);
            while (!this.stop) {
                long startTime = System.currentTimeMillis();
                this.processConnectors();
                long elapsedTime = System.currentTimeMillis() - startTime;
                if ((long)this.interval > elapsedTime) {
                    this.wait((long)this.interval - elapsedTime);
                }
                this.syncContext(false);
            }
        }
        catch (InterruptedException ex) {
            log.debug("Monitoring thread was interrupted", ex);
        }
        log.debug("exiting run()");
    }

    private synchronized boolean isWorkingHost(String host) {
        if (this.workerHost == null) {
            this.workerHost = host;
            return true;
        }
        return host.equals(this.workerHost);
    }

    @Override
    public void testStarted(String host) {
        if (!this.isWorkingHost(host)) {
            return;
        }
        if (this.getProperty("filename") == null || this.getProperty("filename").getStringValue().trim().length() == 0) {
            if (this.getAutoGenerateFiles()) {
                this.setupSaving(this.getAutoFileName());
            } else {
                log.info(this.getPrefix() + " monitoring metrics will not be recorded! Please specify a file name in the gui or run the test with -J" + this.getForceFilePropertyName() + "=true");
            }
        }
        this.ctx = JMeterContextService.getContext();
        this.initiateConnectors();
        this.stop = false;
        this.workerThread = new Thread(this);
        this.workerThread.start();
        super.testStarted(host);
    }

    private void setupSaving(String fileName) {
        SampleSaveConfiguration config = this.getSaveConfig();
        JMeterPluginsUtils.doBestCSVSetup(config);
        this.setSaveConfig(config);
        this.setFilename(fileName);
        log.info(this.getPrefix() + " monitoring metrics will be stored in " + new File(fileName).getAbsolutePath());
    }

    @Override
    public void testEnded(String host) {
        log.debug("Start testEnded");
        this.workerHost = null;
        if (this.workerThread == null) {
            log.debug("End   testEnded workerThread == null");
            return;
        }
        this.stop = true;
        this.shutdownConnectors();
        this.autoFileBaseName = null;
        counter = 0;
        super.testEnded(host);
        log.debug("End   testEnded");
    }

    protected void initiateConnectors() {
    }

    protected void shutdownConnectors() {
    }

    protected void processConnectors() {
        for (MonitoringSampler sampler : this.samplers) {
            sampler.generateSamples(this);
            if (!this.stop) continue;
            break;
        }
    }

    @Override
    public void sampleOccurred(SampleEvent event) {
        this.ctx = JMeterContextService.getContext();
    }

    protected void monitoringSampleOccurred(SampleEvent event) {
        super.sampleOccurred(event);
    }

    @Override
    public void generateSample(double value, String label) {
        MonitoringSampleResult res = new MonitoringSampleResult();
        res.setSampleLabel(label);
        res.setValue(value);
        res.setSuccessful(true);
        SampleEvent e = new SampleEvent(res, this.getPrefix());
        this.monitoringSampleOccurred(e);
    }

    @Override
    public JMeterContext getThreadContext() {
        if (this.ctx != null) {
            return this.ctx;
        }
        return super.getThreadContext();
    }
}

