/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.BeanShellTestElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=0x7FFFFFFF)
public class BeanShellAssertion
extends BeanShellTestElement
implements Assertion {
    private static final Logger log = LoggerFactory.getLogger(BeanShellAssertion.class);
    private static final long serialVersionUID = 4L;
    public static final String FILENAME = "BeanShellAssertion.filename";
    public static final String SCRIPT = "BeanShellAssertion.query";
    public static final String PARAMETERS = "BeanShellAssertion.parameters";
    public static final String RESET_INTERPRETER = "BeanShellAssertion.resetInterpreter";
    public static final String INIT_FILE = "beanshell.assertion.init";

    @Override
    protected String getInitFileProperty() {
        return INIT_FILE;
    }

    @Override
    public String getScript() {
        return this.getPropertyAsString(SCRIPT);
    }

    @Override
    public String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    @Override
    public String getParameters() {
        return this.getPropertyAsString(PARAMETERS);
    }

    @Override
    public boolean isResetInterpreter() {
        return this.getPropertyAsBoolean(RESET_INTERPRETER);
    }

    @Override
    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult(this.getName());
        BeanShellInterpreter bshInterpreter = this.getBeanShellInterpreter();
        if (bshInterpreter == null) {
            result.setFailure(true);
            result.setError(true);
            result.setFailureMessage("BeanShell Interpreter not found");
            return result;
        }
        try {
            bshInterpreter.set("SampleResult", response);
            bshInterpreter.set("Response", response);
            bshInterpreter.set("ResponseData", response.getResponseData());
            bshInterpreter.set("ResponseCode", response.getResponseCode());
            bshInterpreter.set("ResponseMessage", response.getResponseMessage());
            bshInterpreter.set("ResponseHeaders", response.getResponseHeaders());
            bshInterpreter.set("RequestHeaders", response.getRequestHeaders());
            bshInterpreter.set("SampleLabel", response.getSampleLabel());
            bshInterpreter.set("SamplerData", response.getSamplerData());
            bshInterpreter.set("Successful", response.isSuccessful());
            bshInterpreter.set("FailureMessage", "");
            bshInterpreter.set("Failure", false);
            this.processFileOrScript(bshInterpreter);
            result.setFailureMessage(bshInterpreter.get("FailureMessage").toString());
            result.setFailure(Boolean.parseBoolean(bshInterpreter.get("Failure").toString()));
            result.setError(false);
        }
        catch (NoClassDefFoundError ex) {
            log.error("BeanShell Jar missing?", ex);
            result.setError(true);
            result.setFailureMessage("BeanShell Jar missing? " + ex.toString());
            response.setStopThread(true);
        }
        catch (Exception ex) {
            result.setError(true);
            result.setFailureMessage(ex.toString());
            log.warn("Error in BeanShellAssertion", ex);
        }
        return result;
    }
}

