/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONPathAssertion
extends AbstractTestElement
implements Serializable,
Assertion,
ThreadListener {
    private static final Logger log = LoggerFactory.getLogger(JSONPathAssertion.class);
    private static final long serialVersionUID = 2L;
    public static final String JSONPATH = "JSON_PATH";
    public static final String EXPECTEDVALUE = "EXPECTED_VALUE";
    public static final String JSONVALIDATION = "JSONVALIDATION";
    public static final String EXPECT_NULL = "EXPECT_NULL";
    public static final String INVERT = "INVERT";
    public static final String ISREGEX = "ISREGEX";
    private static ThreadLocal<DecimalFormat> decimalFormatter = ThreadLocal.withInitial(JSONPathAssertion::createDecimalFormat);

    private static DecimalFormat createDecimalFormat() {
        DecimalFormat decimalFormatter = new DecimalFormat("#.#");
        decimalFormatter.setMaximumFractionDigits(340);
        decimalFormatter.setMinimumFractionDigits(1);
        return decimalFormatter;
    }

    public String getJsonPath() {
        return this.getPropertyAsString(JSONPATH);
    }

    public void setJsonPath(String jsonPath) {
        this.setProperty(JSONPATH, jsonPath);
    }

    public String getExpectedValue() {
        return this.getPropertyAsString(EXPECTEDVALUE);
    }

    public void setExpectedValue(String expectedValue) {
        this.setProperty(EXPECTEDVALUE, expectedValue);
    }

    public void setJsonValidationBool(boolean jsonValidation) {
        this.setProperty(JSONVALIDATION, jsonValidation);
    }

    public void setExpectNull(boolean val) {
        this.setProperty(EXPECT_NULL, val);
    }

    public boolean isExpectNull() {
        return this.getPropertyAsBoolean(EXPECT_NULL);
    }

    public boolean isJsonValidationBool() {
        return this.getPropertyAsBoolean(JSONVALIDATION);
    }

    public void setInvert(boolean invert) {
        this.setProperty(INVERT, invert);
    }

    public boolean isInvert() {
        return this.getPropertyAsBoolean(INVERT);
    }

    public void setIsRegex(boolean flag) {
        this.setProperty(ISREGEX, flag);
    }

    public boolean isUseRegex() {
        return this.getPropertyAsBoolean(ISREGEX, true);
    }

    private void doAssert(String jsonString) {
        Object value = JsonPath.read((String)jsonString, (String)this.getJsonPath(), (Predicate[])new Predicate[0]);
        if (!this.isJsonValidationBool()) {
            return;
        }
        if (value instanceof JSONArray ? this.arrayMatched((JSONArray)value) : this.isExpectNull() && value == null || this.isEquals(value)) {
            return;
        }
        if (this.isExpectNull()) {
            throw new IllegalStateException(String.format("Value expected to be null, but found '%s'", value));
        }
        String msg = this.isUseRegex() ? "Value expected to match regexp '%s', but it did not match: '%s'" : "Value expected to be '%s', but found '%s'";
        throw new IllegalStateException(String.format(msg, this.getExpectedValue(), JSONPathAssertion.objectToString(value)));
    }

    private boolean arrayMatched(JSONArray value) {
        if (value.isEmpty() && "[]".equals(this.getExpectedValue())) {
            return true;
        }
        for (Object subj : value.toArray()) {
            if ((subj != null || !this.isExpectNull()) && !this.isEquals(subj)) continue;
            return true;
        }
        return this.isEquals(value);
    }

    private boolean isEquals(Object subj) {
        String str = JSONPathAssertion.objectToString(subj);
        if (this.isUseRegex()) {
            Pattern pattern = JMeterUtils.getPatternCache().getPattern(this.getExpectedValue());
            return JMeterUtils.getMatcher().matches(str, pattern);
        }
        return str.equals(this.getExpectedValue());
    }

    @Override
    public AssertionResult getResult(SampleResult samplerResult) {
        AssertionResult result = new AssertionResult(this.getName());
        String responseData = samplerResult.getResponseDataAsString();
        if (responseData.isEmpty()) {
            return result.setResultForNull();
        }
        result.setFailure(false);
        result.setFailureMessage("");
        if (!this.isInvert()) {
            try {
                this.doAssert(responseData);
            }
            catch (Exception e) {
                log.debug("Assertion failed", e);
                result.setFailure(true);
                result.setFailureMessage(e.getMessage());
            }
        } else {
            try {
                this.doAssert(responseData);
                result.setFailure(true);
                if (this.isJsonValidationBool()) {
                    if (this.isExpectNull()) {
                        result.setFailureMessage("Failed that JSONPath " + this.getJsonPath() + " not matches null");
                    } else {
                        result.setFailureMessage("Failed that JSONPath " + this.getJsonPath() + " not matches " + this.getExpectedValue());
                    }
                } else {
                    result.setFailureMessage("Failed that JSONPath not exists: " + this.getJsonPath());
                }
            }
            catch (Exception e) {
                log.debug("Assertion failed, as expected", e);
            }
        }
        return result;
    }

    public static String objectToString(Object subj) {
        String str = subj == null ? "null" : (subj instanceof Map ? new JSONObject((Map)subj).toJSONString() : (subj instanceof Double || subj instanceof Float ? decimalFormatter.get().format(subj) : subj.toString()));
        return str;
    }

    @Override
    public void threadStarted() {
    }

    @Override
    public void threadFinished() {
        decimalFormatter.remove();
    }
}

