/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedAssertion;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.Document;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseAssertion
extends AbstractScopedAssertion
implements Serializable,
Assertion {
    private static final Logger log = LoggerFactory.getLogger(ResponseAssertion.class);
    private static final long serialVersionUID = 242L;
    private static final String TEST_FIELD = "Assertion.test_field";
    private static final String SAMPLE_URL = "Assertion.sample_label";
    private static final String RESPONSE_DATA = "Assertion.response_data";
    private static final String RESPONSE_DATA_AS_DOCUMENT = "Assertion.response_data_as_document";
    private static final String RESPONSE_CODE = "Assertion.response_code";
    private static final String RESPONSE_MESSAGE = "Assertion.response_message";
    private static final String RESPONSE_HEADERS = "Assertion.response_headers";
    private static final String REQUEST_HEADERS = "Assertion.request_headers";
    private static final String REQUEST_DATA = "Assertion.request_data";
    private static final String ASSUME_SUCCESS = "Assertion.assume_success";
    private static final String TEST_STRINGS = "Asserion.test_strings";
    private static final String TEST_TYPE = "Assertion.test_type";
    private static final String CUSTOM_MESSAGE = "Assertion.custom_message";
    private static final int MATCH = 1;
    private static final int CONTAINS = 2;
    private static final int NOT = 4;
    private static final int EQUALS = 8;
    private static final int SUBSTRING = 16;
    private static final int OR = 32;
    private static final int TYPE_MASK = 27;
    private static final int EQUALS_SECTION_DIFF_LEN = JMeterUtils.getPropDefault("assertion.equals_section_diff_len", 100);
    private static final String EQUALS_DIFF_TRUNC = "...";
    private static final String RECEIVED_STR = "****** received  : ";
    private static final String COMPARISON_STR = "****** comparison: ";
    private static final String DIFF_DELTA_START = JMeterUtils.getPropDefault("assertion.equals_diff_delta_start", "[[[");
    private static final String DIFF_DELTA_END = JMeterUtils.getPropDefault("assertion.equals_diff_delta_end", "]]]");

    public ResponseAssertion() {
        this.setProperty(new CollectionProperty(TEST_STRINGS, new ArrayList()));
    }

    @Override
    public void clear() {
        super.clear();
        this.setProperty(new CollectionProperty(TEST_STRINGS, new ArrayList()));
    }

    private void setTestField(String testField) {
        this.setProperty(TEST_FIELD, testField);
    }

    public void setTestFieldURL() {
        this.setTestField(SAMPLE_URL);
    }

    public void setTestFieldResponseCode() {
        this.setTestField(RESPONSE_CODE);
    }

    public void setTestFieldResponseData() {
        this.setTestField(RESPONSE_DATA);
    }

    public void setTestFieldResponseDataAsDocument() {
        this.setTestField(RESPONSE_DATA_AS_DOCUMENT);
    }

    public void setTestFieldResponseMessage() {
        this.setTestField(RESPONSE_MESSAGE);
    }

    public void setTestFieldResponseHeaders() {
        this.setTestField(RESPONSE_HEADERS);
    }

    public void setTestFieldRequestHeaders() {
        this.setTestField(REQUEST_HEADERS);
    }

    public void setTestFieldRequestData() {
        this.setTestField(REQUEST_DATA);
    }

    public void setCustomFailureMessage(String customFailureMessage) {
        this.setProperty(CUSTOM_MESSAGE, customFailureMessage);
    }

    public String getCustomFailureMessage() {
        return this.getPropertyAsString(CUSTOM_MESSAGE);
    }

    public boolean isTestFieldURL() {
        return SAMPLE_URL.equals(this.getTestField());
    }

    public boolean isTestFieldResponseCode() {
        return RESPONSE_CODE.equals(this.getTestField());
    }

    public boolean isTestFieldResponseData() {
        return RESPONSE_DATA.equals(this.getTestField());
    }

    public boolean isTestFieldResponseDataAsDocument() {
        return RESPONSE_DATA_AS_DOCUMENT.equals(this.getTestField());
    }

    public boolean isTestFieldResponseMessage() {
        return RESPONSE_MESSAGE.equals(this.getTestField());
    }

    public boolean isTestFieldResponseHeaders() {
        return RESPONSE_HEADERS.equals(this.getTestField());
    }

    public boolean isTestFieldRequestHeaders() {
        return REQUEST_HEADERS.equals(this.getTestField());
    }

    public boolean isTestFieldRequestData() {
        return REQUEST_DATA.equals(this.getTestField());
    }

    private void setTestType(int testType) {
        this.setProperty(new IntegerProperty(TEST_TYPE, testType));
    }

    private void setTestTypeMasked(int testType) {
        int value = this.getTestType() & 0xFFFFFFE4 | testType;
        this.setProperty(new IntegerProperty(TEST_TYPE, value));
    }

    public void addTestString(String testString) {
        this.getTestStrings().addProperty(new StringProperty(String.valueOf(testString.hashCode()), testString));
    }

    public void clearTestStrings() {
        this.getTestStrings().clear();
    }

    @Override
    public AssertionResult getResult(SampleResult response) {
        return this.evaluateResponse(response);
    }

    public String getTestField() {
        return this.getPropertyAsString(TEST_FIELD);
    }

    public int getTestType() {
        JMeterProperty type = this.getProperty(TEST_TYPE);
        if (type instanceof NullProperty) {
            return 2;
        }
        return type.getIntValue();
    }

    public CollectionProperty getTestStrings() {
        return (CollectionProperty)this.getProperty(TEST_STRINGS);
    }

    public boolean isEqualsType() {
        return (this.getTestType() & 8) != 0;
    }

    public boolean isSubstringType() {
        return (this.getTestType() & 0x10) != 0;
    }

    public boolean isContainsType() {
        return (this.getTestType() & 2) != 0;
    }

    public boolean isMatchType() {
        return (this.getTestType() & 1) != 0;
    }

    public boolean isNotType() {
        return (this.getTestType() & 4) != 0;
    }

    public boolean isOrType() {
        return (this.getTestType() & 0x20) != 0;
    }

    public void setToContainsType() {
        this.setTestTypeMasked(2);
    }

    public void setToMatchType() {
        this.setTestTypeMasked(1);
    }

    public void setToEqualsType() {
        this.setTestTypeMasked(8);
    }

    public void setToSubstringType() {
        this.setTestTypeMasked(16);
    }

    public void setToNotType() {
        this.setTestType(this.getTestType() | 4);
    }

    public void unsetNotType() {
        this.setTestType(this.getTestType() & 0xFFFFFFFB);
    }

    public void setToOrType() {
        this.setTestType(this.getTestType() | 0x20);
    }

    public void unsetOrType() {
        this.setTestType(this.getTestType() & 0xFFFFFFDF);
    }

    public boolean getAssumeSuccess() {
        return this.getPropertyAsBoolean(ASSUME_SUCCESS, false);
    }

    public void setAssumeSuccess(boolean b) {
        this.setProperty(ASSUME_SUCCESS, b);
    }

    private AssertionResult evaluateResponse(SampleResult response) {
        AssertionResult result = new AssertionResult(this.getName());
        if (this.getAssumeSuccess()) {
            response.setSuccessful(true);
        }
        String toCheck = this.getStringToCheck(response);
        result.setFailure(false);
        result.setError(false);
        int testType = this.getTestType();
        boolean notTest = (4 & testType) > 0;
        boolean orTest = (0x20 & testType) > 0;
        boolean contains = this.isContainsType();
        boolean equals = this.isEqualsType();
        boolean substring = this.isSubstringType();
        boolean matches = this.isMatchType();
        log.debug("Test Type Info: contains={}, notTest={}, orTest={}", contains, notTest, orTest);
        if (StringUtils.isEmpty(toCheck)) {
            if (notTest) {
                return result;
            }
            if (log.isDebugEnabled()) {
                log.debug("Not checking empty response field in: {}", (Object)response.getSampleLabel());
            }
            return result.setResultForNull();
        }
        try {
            Perl5Matcher localMatcher = JMeterUtils.getMatcher();
            boolean hasTrue = false;
            ArrayList<String> allCheckMessage = new ArrayList<String>();
            for (JMeterProperty jMeterProperty : this.getTestStrings()) {
                boolean pass;
                String stringPattern = jMeterProperty.getStringValue();
                Pattern pattern = null;
                if (contains || matches) {
                    pattern = JMeterUtils.getPatternCache().getPattern(stringPattern, 32768);
                }
                boolean found = contains ? localMatcher.contains(toCheck, pattern) : (equals ? toCheck.equals(stringPattern) : (substring ? toCheck.contains(stringPattern) : localMatcher.matches(toCheck, pattern)));
                boolean bl = notTest ? !found : (pass = found);
                if (orTest) {
                    if (!pass) {
                        log.debug("Failed: {}", (Object)stringPattern);
                        allCheckMessage.add(this.getFailText(stringPattern, toCheck));
                        continue;
                    }
                    hasTrue = true;
                    break;
                }
                if (!pass) {
                    log.debug("Failed: {}", (Object)stringPattern);
                    result.setFailure(true);
                    String customMsg = this.getCustomFailureMessage();
                    if (StringUtils.isEmpty(customMsg)) {
                        result.setFailureMessage(this.getFailText(stringPattern, toCheck));
                        break;
                    }
                    result.setFailureMessage(customMsg);
                    break;
                }
                log.debug("Passed: {}", (Object)stringPattern);
            }
            if (orTest && !hasTrue) {
                result.setFailure(true);
                String customMsg = this.getCustomFailureMessage();
                if (StringUtils.isEmpty(customMsg)) {
                    result.setFailureMessage(allCheckMessage.stream().collect(Collectors.joining("\t", "", "\t")));
                } else {
                    result.setFailureMessage(customMsg);
                }
            }
        }
        catch (MalformedCachePatternException e) {
            result.setError(true);
            result.setFailure(false);
            result.setFailureMessage("Bad test configuration " + e);
        }
        return result;
    }

    private String getStringToCheck(SampleResult response) {
        String toCheck;
        if (this.isScopeVariable()) {
            toCheck = this.getThreadContext().getVariables().get(this.getVariableName());
        } else if (this.isTestFieldResponseData()) {
            toCheck = response.getResponseDataAsString();
        } else if (this.isTestFieldResponseDataAsDocument()) {
            toCheck = Document.getTextFromDocument(response.getResponseData());
        } else if (this.isTestFieldResponseCode()) {
            toCheck = response.getResponseCode();
        } else if (this.isTestFieldResponseMessage()) {
            toCheck = response.getResponseMessage();
        } else if (this.isTestFieldRequestHeaders()) {
            toCheck = response.getRequestHeaders();
        } else if (this.isTestFieldRequestData()) {
            toCheck = response.getSamplerData();
        } else if (this.isTestFieldResponseHeaders()) {
            toCheck = response.getResponseHeaders();
        } else {
            toCheck = "";
            URL url = response.getURL();
            if (url != null) {
                toCheck = url.toString();
            }
        }
        return toCheck;
    }

    private String getFailText(String stringPattern, String toCheck) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("Test failed: ");
        if (this.isScopeVariable()) {
            sb.append("variable(").append(this.getVariableName()).append(')');
        } else if (this.isTestFieldResponseData()) {
            sb.append("text");
        } else if (this.isTestFieldResponseCode()) {
            sb.append("code");
        } else if (this.isTestFieldResponseMessage()) {
            sb.append("message");
        } else if (this.isTestFieldRequestHeaders()) {
            sb.append("request headers");
        } else if (this.isTestFieldRequestData()) {
            sb.append("request data");
        } else if (this.isTestFieldResponseHeaders()) {
            sb.append("headers");
        } else if (this.isTestFieldResponseDataAsDocument()) {
            sb.append("document");
        } else {
            sb.append("URL");
        }
        switch (this.getTestType()) {
            case 2: 
            case 16: {
                sb.append(" expected to contain ");
                break;
            }
            case 6: 
            case 20: {
                sb.append(" expected not to contain ");
                break;
            }
            case 1: {
                sb.append(" expected to match ");
                break;
            }
            case 5: {
                sb.append(" expected not to match ");
                break;
            }
            case 8: {
                sb.append(" expected to equal ");
                break;
            }
            case 12: {
                sb.append(" expected not to equal ");
                break;
            }
            default: {
                sb.append(" expected something using ");
            }
        }
        sb.append("/");
        if (this.isEqualsType()) {
            sb.append((CharSequence)ResponseAssertion.equalsComparisonText(toCheck, stringPattern));
        } else {
            sb.append(stringPattern);
        }
        sb.append("/");
        return sb.toString();
    }

    private static String trunc(boolean right, String str) {
        if (str.length() <= EQUALS_SECTION_DIFF_LEN) {
            return str;
        }
        if (right) {
            return str.substring(0, EQUALS_SECTION_DIFF_LEN) + EQUALS_DIFF_TRUNC;
        }
        return EQUALS_DIFF_TRUNC + str.substring(str.length() - EQUALS_SECTION_DIFF_LEN);
    }

    private static StringBuilder equalsComparisonText(String received, String comparison) {
        String compDeltaSeq;
        String recDeltaSeq;
        int lastCompDiff;
        int firstDiff;
        int recLength = received.length();
        int compLength = comparison.length();
        int minLength = Math.min(recLength, compLength);
        StringBuilder text = new StringBuilder(Math.max(recLength, compLength) * 2);
        for (firstDiff = 0; firstDiff < minLength && received.charAt(firstDiff) == comparison.charAt(firstDiff); ++firstDiff) {
        }
        String startingEqSeq = firstDiff == 0 ? "" : ResponseAssertion.trunc(false, received.substring(0, firstDiff));
        int lastRecDiff = recLength - 1;
        for (lastCompDiff = compLength - 1; lastRecDiff > firstDiff && lastCompDiff > firstDiff && received.charAt(lastRecDiff) == comparison.charAt(lastCompDiff); --lastRecDiff, --lastCompDiff) {
        }
        String endingEqSeq = ResponseAssertion.trunc(true, received.substring(lastRecDiff + 1, recLength));
        if (endingEqSeq.length() == 0) {
            recDeltaSeq = ResponseAssertion.trunc(true, received.substring(firstDiff, recLength));
            compDeltaSeq = ResponseAssertion.trunc(true, comparison.substring(firstDiff, compLength));
        } else {
            recDeltaSeq = ResponseAssertion.trunc(true, received.substring(firstDiff, lastRecDiff + 1));
            compDeltaSeq = ResponseAssertion.trunc(true, comparison.substring(firstDiff, lastCompDiff + 1));
        }
        StringBuilder pad = new StringBuilder(Math.abs(recDeltaSeq.length() - compDeltaSeq.length()));
        for (int i = 0; i < pad.capacity(); ++i) {
            pad.append(' ');
        }
        if (recDeltaSeq.length() > compDeltaSeq.length()) {
            compDeltaSeq = compDeltaSeq + pad.toString();
        } else {
            recDeltaSeq = recDeltaSeq + pad.toString();
        }
        text.append("\n\n");
        text.append(RECEIVED_STR);
        text.append(startingEqSeq);
        text.append(DIFF_DELTA_START);
        text.append(recDeltaSeq);
        text.append(DIFF_DELTA_END);
        text.append(endingEqSeq);
        text.append("\n\n");
        text.append(COMPARISON_STR);
        text.append(startingEqSeq);
        text.append(DIFF_DELTA_START);
        text.append(compDeltaSeq);
        text.append(DIFF_DELTA_END);
        text.append(endingEqSeq);
        text.append("\n\n");
        return text;
    }
}

