/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedAssertion;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.util.JMeterUtils;

public class SizeAssertion
extends AbstractScopedAssertion
implements Serializable,
Assertion {
    private static final long serialVersionUID = 241L;
    public static final int EQUAL = 1;
    public static final int NOTEQUAL = 2;
    public static final int GREATERTHAN = 3;
    public static final int LESSTHAN = 4;
    public static final int GREATERTHANEQUAL = 5;
    public static final int LESSTHANEQUAL = 6;
    private static final String SIZE_KEY = "SizeAssertion.size";
    private static final String OPERATOR_KEY = "SizeAssertion.operator";
    private static final String TEST_FIELD = "Assertion.test_field";
    private static final String RESPONSE_NETWORK_SIZE = "SizeAssertion.response_network_size";
    private static final String RESPONSE_HEADERS = "SizeAssertion.response_headers";
    private static final String RESPONSE_BODY = "SizeAssertion.response_data";
    private static final String RESPONSE_CODE = "SizeAssertion.response_code";
    private static final String RESPONSE_MESSAGE = "SizeAssertion.response_message";

    @Override
    public AssertionResult getResult(SampleResult response) {
        long resultSize;
        AssertionResult result = new AssertionResult(this.getName());
        result.setFailure(false);
        if (this.isScopeVariable()) {
            String variableName = this.getVariableName();
            String value = this.getThreadContext().getVariables().get(variableName);
            try {
                resultSize = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                result.setFailure(true);
                result.setFailureMessage("Error parsing variable name: " + variableName + " value: " + value);
                return result;
            }
        } else {
            resultSize = this.isTestFieldResponseHeaders() ? (long)response.getHeadersSize() : (this.isTestFieldResponseBody() ? response.getBodySizeAsLong() : (this.isTestFieldResponseCode() ? (long)response.getResponseCode().length() : (this.isTestFieldResponseMessage() ? (long)response.getResponseMessage().length() : response.getBytesAsLong())));
        }
        String msg = this.compareSize(resultSize);
        if (msg.length() > 0) {
            result.setFailure(true);
            Object[] arguments = new Object[]{resultSize, msg, Long.valueOf(this.getAllowedSize())};
            String message = MessageFormat.format(JMeterUtils.getResString("size_assertion_failure"), arguments);
            result.setFailureMessage(message);
        }
        return result;
    }

    public String getAllowedSize() {
        return this.getPropertyAsString(SIZE_KEY);
    }

    public void setCompOper(int operator) {
        this.setProperty(new IntegerProperty(OPERATOR_KEY, operator));
    }

    public int getCompOper() {
        return this.getPropertyAsInt(OPERATOR_KEY);
    }

    public void setAllowedSize(String size) {
        this.setProperty(SIZE_KEY, size);
    }

    public void setAllowedSize(long size) {
        this.setProperty(SIZE_KEY, Long.toString(size));
    }

    private String compareSize(long resultSize) {
        String comparatorErrorMessage;
        boolean result;
        long allowedSize = Long.parseLong(this.getAllowedSize());
        int comp = this.getCompOper();
        switch (comp) {
            case 1: {
                result = resultSize == allowedSize;
                comparatorErrorMessage = JMeterUtils.getResString("size_assertion_comparator_error_equal");
                break;
            }
            case 2: {
                result = resultSize != allowedSize;
                comparatorErrorMessage = JMeterUtils.getResString("size_assertion_comparator_error_notequal");
                break;
            }
            case 3: {
                result = resultSize > allowedSize;
                comparatorErrorMessage = JMeterUtils.getResString("size_assertion_comparator_error_greater");
                break;
            }
            case 4: {
                result = resultSize < allowedSize;
                comparatorErrorMessage = JMeterUtils.getResString("size_assertion_comparator_error_less");
                break;
            }
            case 5: {
                result = resultSize >= allowedSize;
                comparatorErrorMessage = JMeterUtils.getResString("size_assertion_comparator_error_greaterequal");
                break;
            }
            case 6: {
                result = resultSize <= allowedSize;
                comparatorErrorMessage = JMeterUtils.getResString("size_assertion_comparator_error_lessequal");
                break;
            }
            default: {
                result = false;
                comparatorErrorMessage = "ERROR - invalid condition";
            }
        }
        return result ? "" : comparatorErrorMessage;
    }

    private void setTestField(String testField) {
        this.setProperty(TEST_FIELD, testField);
    }

    public void setTestFieldNetworkSize() {
        this.setTestField(RESPONSE_NETWORK_SIZE);
    }

    public void setTestFieldResponseHeaders() {
        this.setTestField(RESPONSE_HEADERS);
    }

    public void setTestFieldResponseBody() {
        this.setTestField(RESPONSE_BODY);
    }

    public void setTestFieldResponseCode() {
        this.setTestField(RESPONSE_CODE);
    }

    public void setTestFieldResponseMessage() {
        this.setTestField(RESPONSE_MESSAGE);
    }

    public String getTestField() {
        return this.getPropertyAsString(TEST_FIELD);
    }

    public boolean isTestFieldNetworkSize() {
        return RESPONSE_NETWORK_SIZE.equals(this.getTestField());
    }

    public boolean isTestFieldResponseHeaders() {
        return RESPONSE_HEADERS.equals(this.getTestField());
    }

    public boolean isTestFieldResponseBody() {
        return RESPONSE_BODY.equals(this.getTestField());
    }

    public boolean isTestFieldResponseCode() {
        return RESPONSE_CODE.equals(this.getTestField());
    }

    public boolean isTestFieldResponseMessage() {
        return RESPONSE_MESSAGE.equals(this.getTestField());
    }
}

