/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.Serializable;
import java.util.concurrent.CompletionException;
import net.sf.saxon.s9api.SaxonApiException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedAssertion;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.XPathUtil;

public class XPath2Assertion
extends AbstractScopedAssertion
implements Serializable,
Assertion {
    private static final long serialVersionUID = 241L;
    private static final String XPATH_KEY = "XPath.xpath";
    private static final String NEGATE_KEY = "XPath.negate";
    private static final String NAMESPACES = "XPath.namespaces";
    public static final String DEFAULT_XPATH = "/";

    @Override
    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult(this.getName());
        result.setFailure(false);
        result.setFailureMessage("");
        String responseData = null;
        if (this.isScopeVariable()) {
            String inputString = this.getThreadContext().getVariables().get(this.getVariableName());
            if (!StringUtils.isEmpty(inputString)) {
                responseData = inputString;
            }
        } else {
            responseData = response.getResponseDataAsString();
        }
        if (responseData == null) {
            return result.setResultForNull();
        }
        try {
            XPathUtil.computeAssertionResultUsingSaxon(result, responseData, this.getXPathString(), this.getNamespaces(), this.isNegated());
        }
        catch (CompletionException | SaxonApiException e) {
            result.setError(true);
            result.setFailureMessage("Exception occurred computing assertion with XPath:" + this.getXPathString() + ", error:" + e.getMessage());
            return result;
        }
        return result;
    }

    public String getXPathString() {
        return this.getPropertyAsString(XPATH_KEY, DEFAULT_XPATH);
    }

    public void setXPathString(String xpath) {
        this.setProperty(new StringProperty(XPATH_KEY, xpath));
    }

    public void setNegated(boolean negate) {
        this.setProperty(new BooleanProperty(NEGATE_KEY, negate));
    }

    public boolean isNegated() {
        return this.getPropertyAsBoolean(NEGATE_KEY, false);
    }

    public void setNamespaces(String namespaces) {
        this.setProperty(NAMESPACES, namespaces);
    }

    public String getNamespaces() {
        return this.getPropertyAsString(NAMESPACES);
    }
}

