/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedAssertion;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.TidyException;
import org.apache.jmeter.util.XPathUtil;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XPathAssertion
extends AbstractScopedAssertion
implements Serializable,
Assertion {
    private static final Logger log = LoggerFactory.getLogger(XPathAssertion.class);
    private static final long serialVersionUID = 241L;
    private static final String XPATH_KEY = "XPath.xpath";
    private static final String WHITESPACE_KEY = "XPath.whitespace";
    private static final String VALIDATE_KEY = "XPath.validate";
    private static final String TOLERANT_KEY = "XPath.tolerant";
    private static final String NEGATE_KEY = "XPath.negate";
    private static final String NAMESPACE_KEY = "XPath.namespace";
    private static final String QUIET_KEY = "XPath.quiet";
    private static final String REPORT_ERRORS_KEY = "XPath.report_errors";
    private static final String SHOW_WARNINGS_KEY = "XPath.show_warnings";
    private static final String DOWNLOAD_DTDS = "XPath.download_dtds";
    public static final String DEFAULT_XPATH = "/";

    @Override
    public AssertionResult getResult(SampleResult response) {
        AssertionResult result = new AssertionResult(this.getName());
        result.setFailure(false);
        result.setFailureMessage("");
        byte[] responseData = null;
        Document doc = null;
        try {
            if (this.isScopeVariable()) {
                String inputString = this.getThreadContext().getVariables().get(this.getVariableName());
                if (!StringUtils.isEmpty(inputString)) {
                    responseData = inputString.getBytes(StandardCharsets.UTF_8);
                }
            } else {
                responseData = response.getResponseData();
            }
            if (responseData == null || responseData.length == 0) {
                return result.setResultForNull();
            }
            if (log.isDebugEnabled()) {
                log.debug("Validation is set to {}, Whitespace is set to {}, Tolerant is set to {}", this.isValidating(), this.isWhitespace(), this.isTolerant());
            }
            boolean isXML = JOrphanUtils.isXML(responseData);
            doc = XPathUtil.makeDocument(new ByteArrayInputStream(responseData), this.isValidating(), this.isWhitespace(), this.isNamespace(), this.isTolerant(), this.isQuiet(), this.showWarnings(), this.reportErrors(), isXML, this.isDownloadDTDs());
        }
        catch (SAXException e) {
            log.debug("Caught sax exception.", e);
            result.setError(true);
            result.setFailureMessage("SAXException: " + e.getMessage());
            return result;
        }
        catch (IOException e) {
            log.warn("Cannot parse result content.", e);
            result.setError(true);
            result.setFailureMessage("IOException: " + e.getMessage());
            return result;
        }
        catch (ParserConfigurationException e) {
            log.warn("Cannot parse result content.", e);
            result.setError(true);
            result.setFailureMessage("ParserConfigurationException: " + e.getMessage());
            return result;
        }
        catch (TidyException e) {
            result.setError(true);
            result.setFailureMessage(e.getMessage());
            return result;
        }
        if (doc == null || doc.getDocumentElement() == null) {
            result.setError(true);
            result.setFailureMessage("Document is null, probably not parsable");
            return result;
        }
        XPathUtil.computeAssertionResult(result, doc, this.getXPathString(), this.isNegated());
        return result;
    }

    public String getXPathString() {
        return this.getPropertyAsString(XPATH_KEY, DEFAULT_XPATH);
    }

    public void setXPathString(String xpath) {
        this.setProperty(new StringProperty(XPATH_KEY, xpath));
    }

    public void setWhitespace(boolean whitespace) {
        this.setProperty(new BooleanProperty(WHITESPACE_KEY, whitespace));
    }

    public void setValidating(boolean validate) {
        this.setProperty(new BooleanProperty(VALIDATE_KEY, validate));
    }

    public void setNamespace(boolean namespace) {
        this.setProperty(new BooleanProperty(NAMESPACE_KEY, namespace));
    }

    public void setTolerant(boolean tolerant) {
        this.setProperty(new BooleanProperty(TOLERANT_KEY, tolerant));
    }

    public void setNegated(boolean negate) {
        this.setProperty(new BooleanProperty(NEGATE_KEY, negate));
    }

    public boolean isWhitespace() {
        return this.getPropertyAsBoolean(WHITESPACE_KEY, false);
    }

    public boolean isValidating() {
        return this.getPropertyAsBoolean(VALIDATE_KEY, false);
    }

    public boolean isNamespace() {
        return this.getPropertyAsBoolean(NAMESPACE_KEY, false);
    }

    public boolean isTolerant() {
        return this.getPropertyAsBoolean(TOLERANT_KEY, false);
    }

    public boolean isNegated() {
        return this.getPropertyAsBoolean(NEGATE_KEY, false);
    }

    public void setReportErrors(boolean val) {
        this.setProperty(REPORT_ERRORS_KEY, val, false);
    }

    public boolean reportErrors() {
        return this.getPropertyAsBoolean(REPORT_ERRORS_KEY, false);
    }

    public void setShowWarnings(boolean val) {
        this.setProperty(SHOW_WARNINGS_KEY, val, false);
    }

    public boolean showWarnings() {
        return this.getPropertyAsBoolean(SHOW_WARNINGS_KEY, false);
    }

    public void setQuiet(boolean val) {
        this.setProperty(QUIET_KEY, val, true);
    }

    public boolean isQuiet() {
        return this.getPropertyAsBoolean(QUIET_KEY, true);
    }

    public void setDownloadDTDs(boolean val) {
        this.setProperty(DOWNLOAD_DTDS, val, false);
    }

    public boolean isDownloadDTDs() {
        return this.getPropertyAsBoolean(DOWNLOAD_DTDS, false);
    }
}

