/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.jmeter.assertions.BeanShellAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.FilePanelEntry;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.util.JMeterUtils;

@GUIMenuSortOrder(value=0x7FFFFFFF)
@TestElementMetadata(labelResource="bsh_assertion_title")
public class BeanShellAssertionGui
extends AbstractAssertionGui {
    private static final long serialVersionUID = 240L;
    private JCheckBox resetInterpreter;
    private final FilePanelEntry filename = new FilePanelEntry(JMeterUtils.getResString("bsh_script_file"), ".bsh");
    private JTextField parameters;
    private JSyntaxTextArea scriptField;

    public BeanShellAssertionGui() {
        this.init();
    }

    @Override
    public void configure(TestElement element) {
        this.scriptField.setInitialText(element.getPropertyAsString("BeanShellAssertion.query"));
        this.scriptField.setCaretPosition(0);
        this.filename.setFilename(element.getPropertyAsString("BeanShellAssertion.filename"));
        this.parameters.setText(element.getPropertyAsString("BeanShellAssertion.parameters"));
        this.resetInterpreter.setSelected(element.getPropertyAsBoolean("BeanShellAssertion.resetInterpreter"));
        super.configure(element);
    }

    @Override
    public TestElement createTestElement() {
        BeanShellAssertion sampler = new BeanShellAssertion();
        this.modifyTestElement(sampler);
        return sampler;
    }

    @Override
    public void modifyTestElement(TestElement te) {
        te.clear();
        super.configureTestElement(te);
        te.setProperty("BeanShellAssertion.query", this.scriptField.getText());
        te.setProperty("BeanShellAssertion.filename", this.filename.getFilename());
        te.setProperty("BeanShellAssertion.parameters", this.parameters.getText());
        te.setProperty(new BooleanProperty("BeanShellAssertion.resetInterpreter", this.resetInterpreter.isSelected()));
    }

    @Override
    public String getLabelResource() {
        return "bsh_assertion_title";
    }

    private JPanel createFilenamePanel() {
        JPanel filenamePanel = new JPanel(new BorderLayout());
        filenamePanel.add((Component)this.filename, "Center");
        return filenamePanel;
    }

    private JPanel createResetPanel() {
        this.resetInterpreter = new JCheckBox(JMeterUtils.getResString("bsh_script_reset_interpreter"));
        this.resetInterpreter.setName("BeanShellAssertion.parameters");
        JPanel resetInterpreterPanel = new JPanel(new BorderLayout());
        resetInterpreterPanel.add((Component)this.resetInterpreter, "West");
        return resetInterpreterPanel;
    }

    private JPanel createParameterPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString("bsh_script_parameters"));
        this.parameters = new JTextField(10);
        this.parameters.setName("BeanShellAssertion.parameters");
        label.setLabelFor(this.parameters);
        JPanel parameterPanel = new JPanel(new BorderLayout(5, 0));
        parameterPanel.add((Component)label, "West");
        parameterPanel.add((Component)this.parameters, "Center");
        return parameterPanel;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(this.makeTitlePanel());
        box.add(this.createResetPanel());
        box.add(this.createParameterPanel());
        box.add(this.createFilenamePanel());
        this.add((Component)box, "North");
        JPanel panel = this.createScriptPanel();
        this.add((Component)panel, "Center");
        this.add(Box.createVerticalStrut(panel.getPreferredSize().height), "West");
    }

    private JPanel createScriptPanel() {
        this.scriptField = JSyntaxTextArea.getInstance(20, 20);
        JLabel label = new JLabel(JMeterUtils.getResString("bsh_assertion_script"));
        label.setLabelFor((Component)((Object)this.scriptField));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)((Object)JTextScrollPane.getInstance(this.scriptField)), "Center");
        JTextArea explain = new JTextArea(JMeterUtils.getResString("bsh_assertion_script_variables"));
        explain.setLineWrap(true);
        explain.setEditable(false);
        explain.setBackground(this.getBackground());
        panel.add((Component)explain, "South");
        return panel;
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.filename.setFilename("");
        this.parameters.setText("");
        this.scriptField.setInitialText("");
        this.resetInterpreter.setSelected(false);
    }
}

