/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.assertions.DurationAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="duration_assertion_title")
public class DurationAssertionGui
extends AbstractAssertionGui {
    private static final long serialVersionUID = 240L;
    private JTextField duration;

    public DurationAssertionGui() {
        this.init();
    }

    @Override
    public String getLabelResource() {
        return "duration_assertion_title";
    }

    public String getDurationAttributesTitle() {
        return JMeterUtils.getResString("duration_assertion_duration_test");
    }

    @Override
    public TestElement createTestElement() {
        DurationAssertion el = new DurationAssertion();
        this.modifyTestElement(el);
        return el;
    }

    @Override
    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        if (el instanceof DurationAssertion) {
            DurationAssertion assertion = (DurationAssertion)el;
            assertion.setProperty("DurationAssertion.duration", this.duration.getText());
            this.saveScopeSettings(assertion);
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.duration.setText("");
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        if (el instanceof DurationAssertion) {
            DurationAssertion da = (DurationAssertion)el;
            this.duration.setText(da.getPropertyAsString("DurationAssertion.duration"));
            this.showScopeSettings(da);
        }
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(this.makeBorder());
        this.add((Component)this.makeTitlePanel(), "North");
        VerticalPanel mainPanel = new VerticalPanel();
        ((Container)mainPanel).add(this.createScopePanel());
        VerticalPanel durationPanel = new VerticalPanel();
        durationPanel.setBorder(BorderFactory.createTitledBorder(this.getDurationAttributesTitle()));
        JPanel labelPanel = new JPanel(new BorderLayout(5, 0));
        JLabel durationLabel = new JLabel(JMeterUtils.getResString("duration_assertion_label"));
        labelPanel.add((Component)durationLabel, "West");
        this.duration = new JTextField();
        labelPanel.add((Component)this.duration, "Center");
        durationLabel.setLabelFor(this.duration);
        durationPanel.add(labelPanel);
        ((Container)mainPanel).add(durationPanel);
        this.add((Component)mainPanel, "Center");
    }
}

