/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.jmeter.assertions.HTMLAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestElementMetadata(labelResource="html_assertion_title")
public class HTMLAssertionGui
extends AbstractAssertionGui
implements KeyListener,
ActionListener {
    private static final Logger log = LoggerFactory.getLogger(HTMLAssertionGui.class);
    private static final long serialVersionUID = 2L;
    private static final String WARNING_THRESHOLD_FIELD = "warningThresholdField";
    private static final String ERROR_THRESHOLD_FIELD = "errorThresholdField";
    private JTextField errorThresholdField = null;
    private JTextField warningThresholdField = null;
    private JCheckBox errorsOnly = null;
    private JComboBox<String> docTypeBox = null;
    private JRadioButton htmlRadioButton = null;
    private JRadioButton xhtmlRadioButton = null;
    private JRadioButton xmlRadioButton = null;
    private FilePanel filePanel = null;

    public HTMLAssertionGui() {
        this.init();
    }

    @Override
    public String getLabelResource() {
        return "html_assertion_title";
    }

    @Override
    public TestElement createTestElement() {
        HTMLAssertion el = new HTMLAssertion();
        this.modifyTestElement(el);
        return el;
    }

    @Override
    public void modifyTestElement(TestElement inElement) {
        log.debug("HTMLAssertionGui.modifyTestElement() called");
        this.configureTestElement(inElement);
        String errorThresholdString = this.errorThresholdField.getText();
        long errorThreshold = 0L;
        try {
            errorThreshold = Long.parseLong(errorThresholdString);
        }
        catch (NumberFormatException e) {
            errorThreshold = 0L;
        }
        ((HTMLAssertion)inElement).setErrorThreshold(errorThreshold);
        String warningThresholdString = this.warningThresholdField.getText();
        long warningThreshold = 0L;
        try {
            warningThreshold = Long.parseLong(warningThresholdString);
        }
        catch (NumberFormatException e) {
            warningThreshold = 0L;
        }
        ((HTMLAssertion)inElement).setWarningThreshold(warningThreshold);
        String docTypeString = this.docTypeBox.getSelectedItem().toString();
        ((HTMLAssertion)inElement).setDoctype(docTypeString);
        boolean trackErrorsOnly = this.errorsOnly.isSelected();
        ((HTMLAssertion)inElement).setErrorsOnly(trackErrorsOnly);
        if (this.htmlRadioButton.isSelected()) {
            ((HTMLAssertion)inElement).setHTML();
        } else if (this.xhtmlRadioButton.isSelected()) {
            ((HTMLAssertion)inElement).setXHTML();
        } else {
            ((HTMLAssertion)inElement).setXML();
        }
        ((HTMLAssertion)inElement).setFilename(this.filePanel.getFilename());
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.docTypeBox.setSelectedIndex(0);
        this.htmlRadioButton.setSelected(true);
        this.xhtmlRadioButton.setSelected(false);
        this.xmlRadioButton.setSelected(false);
        this.errorThresholdField.setText("0");
        this.warningThresholdField.setText("0");
        this.filePanel.setFilename("");
        this.errorsOnly.setSelected(false);
    }

    @Override
    public void configure(TestElement inElement) {
        super.configure(inElement);
        HTMLAssertion lAssertion = (HTMLAssertion)inElement;
        this.errorThresholdField.setText(String.valueOf(lAssertion.getErrorThreshold()));
        this.warningThresholdField.setText(String.valueOf(lAssertion.getWarningThreshold()));
        this.errorsOnly.setSelected(lAssertion.isErrorsOnly());
        this.docTypeBox.setSelectedItem(lAssertion.getDoctype());
        if (lAssertion.isHTML()) {
            this.htmlRadioButton.setSelected(true);
        } else if (lAssertion.isXHTML()) {
            this.xhtmlRadioButton.setSelected(true);
        } else {
            this.xmlRadioButton.setSelected(true);
        }
        if (lAssertion.isErrorsOnly()) {
            this.warningThresholdField.setEnabled(false);
            this.warningThresholdField.setEditable(false);
        } else {
            this.warningThresholdField.setEnabled(true);
            this.warningThresholdField.setEditable(true);
        }
        this.filePanel.setFilename(lAssertion.getFilename());
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(this.makeBorder());
        this.add((Component)this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        VerticalPanel assertionPanel = new VerticalPanel();
        assertionPanel.setBorder(BorderFactory.createTitledBorder("Tidy Settings"));
        HorizontalPanel docTypePanel = new HorizontalPanel();
        this.docTypeBox = new JComboBox<String>(new String[]{"omit", "auto", "strict", "loose"});
        docTypePanel.add(new JLabel("Doctype:"));
        docTypePanel.add(this.docTypeBox);
        assertionPanel.add(docTypePanel);
        VerticalPanel formatPanel = new VerticalPanel();
        formatPanel.setBorder(BorderFactory.createTitledBorder("Format"));
        this.htmlRadioButton = new JRadioButton("HTML", true);
        this.xhtmlRadioButton = new JRadioButton("XHTML", false);
        this.xmlRadioButton = new JRadioButton("XML", false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.htmlRadioButton);
        buttonGroup.add(this.xhtmlRadioButton);
        buttonGroup.add(this.xmlRadioButton);
        formatPanel.add(this.htmlRadioButton);
        formatPanel.add(this.xhtmlRadioButton);
        formatPanel.add(this.xmlRadioButton);
        assertionPanel.add(formatPanel);
        this.errorsOnly = new JCheckBox("Errors only", false);
        this.errorsOnly.addActionListener(this);
        assertionPanel.add(this.errorsOnly);
        HorizontalPanel thresholdPanel = new HorizontalPanel();
        thresholdPanel.add(new JLabel("Error threshold:"));
        this.errorThresholdField = new JTextField("0", 5);
        this.errorThresholdField.setName(ERROR_THRESHOLD_FIELD);
        this.errorThresholdField.addKeyListener(this);
        thresholdPanel.add(this.errorThresholdField);
        thresholdPanel.add(new JLabel("Warning threshold:"));
        this.warningThresholdField = new JTextField("0", 5);
        this.warningThresholdField.setName(WARNING_THRESHOLD_FIELD);
        this.warningThresholdField.addKeyListener(this);
        thresholdPanel.add(this.warningThresholdField);
        assertionPanel.add(thresholdPanel);
        this.filePanel = new FilePanel(JMeterUtils.getResString("html_assertion_file"), ".txt");
        assertionPanel.add(this.filePanel);
        mainPanel.add((Component)assertionPanel, "North");
        this.add((Component)mainPanel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.errorsOnly.isSelected()) {
            this.warningThresholdField.setEnabled(false);
            this.warningThresholdField.setEditable(false);
        } else {
            this.warningThresholdField.setEnabled(true);
            this.warningThresholdField.setEditable(true);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        String fieldName = e.getComponent().getName();
        if (fieldName.equals(WARNING_THRESHOLD_FIELD)) {
            this.validateInteger(this.warningThresholdField);
        }
        if (fieldName.equals(ERROR_THRESHOLD_FIELD)) {
            this.validateInteger(this.errorThresholdField);
        }
    }

    private void validateInteger(JTextField field) {
        block2: {
            try {
                Integer.parseInt(field.getText());
            }
            catch (NumberFormatException nfe) {
                int length = field.getText().length();
                if (length <= 0) break block2;
                JOptionPane.showMessageDialog(this, "Only digits allowed", "Invalid data", 2);
                field.setText(field.getText().substring(0, length - 1));
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

