/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import org.apache.jmeter.assertions.XPath2Assertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.assertions.gui.XPath2Panel;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@GUIMenuSortOrder(value=50)
@TestElementMetadata(labelResource="xpath2_assertion_title")
public class XPath2AssertionGui
extends AbstractAssertionGui {
    private static final long serialVersionUID = 240L;
    private XPath2Panel xpath;

    public XPath2AssertionGui() {
        this.init();
    }

    @Override
    public String getLabelResource() {
        return "xpath2_assertion_title";
    }

    @Override
    public TestElement createTestElement() {
        XPath2Assertion el = new XPath2Assertion();
        this.modifyTestElement(el);
        return el;
    }

    public String getXPathAttributesTitle() {
        return JMeterUtils.getResString("xpath2_assertion_test");
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        XPath2Assertion assertion = (XPath2Assertion)el;
        this.showScopeSettings(assertion, true);
        this.xpath.setXPath(assertion.getXPathString());
        this.xpath.setNegated(assertion.isNegated());
        this.xpath.setNamespaces(assertion.getNamespaces());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box topBox = Box.createVerticalBox();
        topBox.add(this.makeTitlePanel());
        topBox.add(this.createScopePanel(true));
        this.add((Component)topBox, "North");
        JPanel sizePanel = new JPanel(new BorderLayout());
        sizePanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        sizePanel.setBorder(BorderFactory.createTitledBorder(this.getXPathAttributesTitle()));
        this.xpath = new XPath2Panel();
        sizePanel.add(this.xpath);
        this.add((Component)sizePanel, "Center");
    }

    @Override
    public void modifyTestElement(TestElement el) {
        super.configureTestElement(el);
        if (el instanceof XPath2Assertion) {
            XPath2Assertion assertion = (XPath2Assertion)el;
            this.saveScopeSettings(assertion);
            assertion.setNegated(this.xpath.isNegated());
            assertion.setXPathString(this.xpath.getXPath());
            assertion.setNamespaces(this.xpath.getNamespaces());
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.xpath.setXPath("/");
        this.xpath.setNegated(false);
        this.xpath.setNamespaces("");
    }
}

