/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.XPathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPath2Panel
extends JPanel {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(XPath2Panel.class);
    private JCheckBox negated;
    private JSyntaxTextArea xpath;
    private JButton checkXPath;
    private JSyntaxTextArea namespacesTA;

    public String getNamespaces() {
        return this.namespacesTA.getText();
    }

    public void setNamespaces(String namespaces) {
        this.namespacesTA.setText(namespaces);
    }

    public XPath2Panel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        Box topBox = Box.createVerticalBox();
        Box box = Box.createHorizontalBox();
        box.add(this.getNegatedCheckBox());
        box.add(Box.createHorizontalGlue());
        box.add(this.getCheckXPathButton());
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalGlue());
        topBox.add(box);
        topBox.add(this.makeParameterPanel());
        this.add((Component)topBox, "North");
        this.add((Component)((Object)JTextScrollPane.getInstance(this.getXPathField())), "Center");
        this.setDefaultValues();
    }

    private JPanel makeParameterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.initConstraints(gbc);
        panel.add((Component)new JLabel(JMeterUtils.getResString("xpath_extractor_user_namespaces")), gbc.clone());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.namespacesTA = JSyntaxTextArea.getInstance(5, 80);
        panel.add((Component)((Object)JTextScrollPane.getInstance(this.namespacesTA, true)), gbc.clone());
        this.resetContraints(gbc);
        return panel;
    }

    private void resetContraints(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
    }

    private void initConstraints(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
    }

    public void setDefaultValues() {
        this.setXPath("/");
        this.setNegated(false);
    }

    public String getXPath() {
        return this.xpath.getText();
    }

    public void setXPath(String xpath) {
        this.xpath.setInitialText(xpath);
    }

    public boolean isNegated() {
        return this.negated.isSelected();
    }

    public void setNegated(boolean negated) {
        this.negated.setSelected(negated);
    }

    public JCheckBox getNegatedCheckBox() {
        if (this.negated == null) {
            this.negated = new JCheckBox(JMeterUtils.getResString("xpath2_assertion_negate"), false);
        }
        return this.negated;
    }

    public JButton getCheckXPathButton() {
        if (this.checkXPath == null) {
            this.checkXPath = new JButton(JMeterUtils.getResString("xpath2_assertion_button"));
            this.checkXPath.addActionListener(e -> XPath2Panel.validXPath(this.xpath.getText(), true, this.getNamespaces()));
        }
        return this.checkXPath;
    }

    public JSyntaxTextArea getXPathField() {
        if (this.xpath == null) {
            this.xpath = JSyntaxTextArea.getInstance(20, 80);
            this.xpath.setLanguage("xpath");
        }
        return this.xpath;
    }

    public boolean isShowNegated() {
        return this.getNegatedCheckBox().isVisible();
    }

    public void setShowNegated(boolean showNegate) {
        this.getNegatedCheckBox().setVisible(showNegate);
    }

    public static boolean validXPath(String xpathString, boolean showDialog, String namespaces) {
        String ret = null;
        boolean success = true;
        Document testDoc = null;
        try {
            testDoc = XPathUtil.makeDocumentBuilder(false, false, false, false).newDocument();
            Element el = testDoc.createElement("root");
            testDoc.appendChild(el);
            XPathUtil.validateXPath2(testDoc, xpathString, namespaces);
        }
        catch (IllegalArgumentException | ParserConfigurationException | TransformerException e) {
            log.warn("Exception while validating XPath.", e);
            success = false;
            ret = e.getLocalizedMessage();
        }
        if (showDialog) {
            JOptionPane.showMessageDialog(null, success ? JMeterUtils.getResString("xpath_assertion_valid") : ret, success ? JMeterUtils.getResString("xpath_assertion_valid") : JMeterUtils.getResString("xpath_assertion_failed"), success ? 1 : 0);
        }
        return success;
    }
}

