/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import org.apache.jmeter.assertions.XPathAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.assertions.gui.XMLConfPanel;
import org.apache.jmeter.assertions.gui.XPathPanel;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="xpath_assertion_title")
public class XPathAssertionGui
extends AbstractAssertionGui {
    private static final long serialVersionUID = 240L;
    private XPathPanel xpath;
    private XMLConfPanel xml;

    public XPathAssertionGui() {
        this.init();
    }

    @Override
    public String getLabelResource() {
        return "xpath_assertion_title";
    }

    @Override
    public TestElement createTestElement() {
        XPathAssertion el = new XPathAssertion();
        this.modifyTestElement(el);
        return el;
    }

    public String getXPathAttributesTitle() {
        return JMeterUtils.getResString("xpath_assertion_test");
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        XPathAssertion assertion = (XPathAssertion)el;
        this.showScopeSettings(assertion, true);
        this.xpath.setXPath(assertion.getXPathString());
        this.xpath.setNegated(assertion.isNegated());
        this.xml.configure(assertion);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box topBox = Box.createVerticalBox();
        topBox.add(this.makeTitlePanel());
        topBox.add(this.createScopePanel(true));
        this.xml = new XMLConfPanel();
        this.xml.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("xpath_assertion_option")));
        topBox.add(this.xml);
        this.add((Component)topBox, "North");
        JPanel sizePanel = new JPanel(new BorderLayout());
        sizePanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        sizePanel.setBorder(BorderFactory.createTitledBorder(this.getXPathAttributesTitle()));
        this.xpath = new XPathPanel();
        sizePanel.add(this.xpath);
        this.add((Component)sizePanel, "Center");
    }

    @Override
    public void modifyTestElement(TestElement el) {
        super.configureTestElement(el);
        if (el instanceof XPathAssertion) {
            XPathAssertion assertion = (XPathAssertion)el;
            this.saveScopeSettings(assertion);
            assertion.setNegated(this.xpath.isNegated());
            assertion.setXPathString(this.xpath.getXPath());
            this.xml.modifyTestElement(assertion);
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.xpath.setXPath("/");
        this.xpath.setNegated(false);
        this.xml.setDefaultValues();
    }
}

