/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config;

import java.beans.PropertyDescriptor;
import org.apache.jmeter.config.CSVDataSet;
import org.apache.jmeter.testbeans.BeanInfoSupport;
import org.apache.jmeter.testbeans.gui.FileEditor;
import org.apache.jmeter.testbeans.gui.TypeEditor;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;

public class CSVDataSetBeanInfo
extends BeanInfoSupport {
    private static final String FILENAME = "filename";
    private static final String FILE_ENCODING = "fileEncoding";
    private static final String VARIABLE_NAMES = "variableNames";
    private static final String IGNORE_FIRST_LINE = "ignoreFirstLine";
    private static final String DELIMITER = "delimiter";
    private static final String RECYCLE = "recycle";
    private static final String STOPTHREAD = "stopThread";
    private static final String QUOTED_DATA = "quotedData";
    private static final String SHAREMODE = "shareMode";
    private static final String[] SHARE_TAGS = new String[3];
    static final int SHARE_ALL = 0;
    static final int SHARE_GROUP = 1;
    static final int SHARE_THREAD = 2;

    public CSVDataSetBeanInfo() {
        super(CSVDataSet.class);
        this.createPropertyGroup("csv_data", new String[]{FILENAME, FILE_ENCODING, VARIABLE_NAMES, IGNORE_FIRST_LINE, DELIMITER, QUOTED_DATA, RECYCLE, STOPTHREAD, SHAREMODE});
        PropertyDescriptor p = this.property(FILENAME);
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        p.setValue("notExpression", Boolean.TRUE);
        p.setPropertyEditorClass(FileEditor.class);
        p = this.property(FILE_ENCODING, TypeEditor.ComboStringEditor);
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        p.setValue("tags", this.getListFileEncoding());
        p = this.property(VARIABLE_NAMES);
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        p.setValue("notExpression", Boolean.TRUE);
        p = this.property(IGNORE_FIRST_LINE);
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", Boolean.FALSE);
        p = this.property(DELIMITER);
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", ",");
        p.setValue("notExpression", Boolean.TRUE);
        p = this.property(QUOTED_DATA);
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", Boolean.FALSE);
        p = this.property(RECYCLE);
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", Boolean.TRUE);
        p = this.property(STOPTHREAD);
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", Boolean.FALSE);
        p = this.property(SHAREMODE, TypeEditor.ComboStringEditor);
        p.setValue("resourceBundle", this.getBeanDescriptor().getValue("resourceBundle"));
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", SHARE_TAGS[0]);
        p.setValue("notOther", Boolean.FALSE);
        p.setValue("notExpression", Boolean.FALSE);
        p.setValue("tags", SHARE_TAGS);
    }

    public static int getShareModeAsInt(String mode) {
        if (mode == null || mode.length() == 0) {
            return 0;
        }
        for (int i = 0; i < SHARE_TAGS.length; ++i) {
            if (!SHARE_TAGS[i].equals(mode)) continue;
            return i;
        }
        return -1;
    }

    public static String[] getShareTags() {
        String[] copy = new String[SHARE_TAGS.length];
        System.arraycopy(SHARE_TAGS, 0, copy, 0, SHARE_TAGS.length);
        return copy;
    }

    private String[] getListFileEncoding() {
        return JOrphanUtils.split(JMeterUtils.getPropDefault("csvdataset.file.encoding_list", ""), "|");
    }

    static {
        CSVDataSetBeanInfo.SHARE_TAGS[0] = "shareMode.all";
        CSVDataSetBeanInfo.SHARE_TAGS[1] = "shareMode.group";
        CSVDataSetBeanInfo.SHARE_TAGS[2] = "shareMode.thread";
    }
}

