/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config;

import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.util.JMeterStopTestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestElementMetadata(labelResource="displayName")
public class KeystoreConfig
extends ConfigTestElement
implements TestBean,
TestStateListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(KeystoreConfig.class);
    private static final String KEY_STORE_START_INDEX = "https.keyStoreStartIndex";
    private static final String KEY_STORE_END_INDEX = "https.keyStoreEndIndex";
    private String startIndex;
    private String endIndex;
    private String preload;
    private String clientCertAliasVarName;

    @Override
    public void testEnded() {
        this.testEnded(null);
    }

    @Override
    public void testEnded(String host) {
        log.info("Destroying Keystore");
        SSLManager.getInstance().destroyKeystore();
    }

    @Override
    public void testStarted() {
        this.testStarted(null);
    }

    @Override
    public void testStarted(String host) {
        String reuseSSLContext = JMeterUtils.getProperty("https.use.cached.ssl.context");
        if (StringUtils.isEmpty(reuseSSLContext) || "true".equals(reuseSSLContext)) {
            log.warn("https.use.cached.ssl.context property must be set to false to ensure Multiple Certificates are used");
        }
        int startIndexAsInt = JMeterUtils.getPropDefault(KEY_STORE_START_INDEX, 0);
        int endIndexAsInt = JMeterUtils.getPropDefault(KEY_STORE_END_INDEX, -1);
        if (!StringUtils.isEmpty(this.startIndex)) {
            try {
                startIndexAsInt = Integer.parseInt(this.startIndex);
            }
            catch (NumberFormatException e) {
                log.warn("Failed parsing startIndex: {}, will default to: {}, error message: {}", this.startIndex, startIndexAsInt, e, e);
            }
        }
        if (!StringUtils.isEmpty(this.endIndex)) {
            try {
                endIndexAsInt = Integer.parseInt(this.endIndex);
            }
            catch (NumberFormatException e) {
                log.warn("Failed parsing endIndex: {}, will default to: {}, error message: {}", this.endIndex, endIndexAsInt, e, e);
            }
        }
        if (endIndexAsInt != -1 && startIndexAsInt > endIndexAsInt) {
            throw new JMeterStopTestException("Keystore Config error : Alias start index must be lower than Alias end index");
        }
        log.info("Configuring Keystore with (preload: '{}', startIndex: {}, endIndex: {}, clientCertAliasVarName: '{}')", this.preload, startIndexAsInt, endIndexAsInt, this.clientCertAliasVarName);
        SSLManager.getInstance().configureKeystore(Boolean.parseBoolean(this.preload), startIndexAsInt, endIndexAsInt, this.clientCertAliasVarName);
    }

    public String getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(String endIndex) {
        this.endIndex = endIndex;
    }

    public String getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(String startIndex) {
        this.startIndex = startIndex;
    }

    public String getPreload() {
        return this.preload;
    }

    public void setPreload(String preload) {
        this.preload = preload;
    }

    public String getClientCertAliasVarName() {
        return this.clientCertAliasVarName;
    }

    public void setClientCertAliasVarName(String clientCertAliasVarName) {
        this.clientCertAliasVarName = clientCertAliasVarName;
    }
}

