/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JViewport;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.config.gui.RowDetailDialog;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.reflect.Functor;

@TestElementMetadata(labelResource="user_defined_variables")
public class ArgumentsPanel
extends AbstractConfigGui
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private JLabel tableLabel;
    private transient JTable table;
    protected transient ObjectTableModel tableModel;
    private JComponent mainPanel;
    private JButton add;
    private JButton delete;
    private Color background;
    private final boolean standalone;
    private JButton up;
    private JButton down;
    private JButton showDetail;
    private final boolean enableUpDown;
    private final boolean disableButtons;
    private static final String ADD = "add";
    private static final String ADD_FROM_CLIPBOARD = "addFromClipboard";
    private static final String DELETE = "delete";
    private static final String UP = "up";
    private static final String DOWN = "down";
    private static final String CLIPBOARD_LINE_DELIMITERS = "\n";
    private static final String CLIPBOARD_ARG_DELIMITERS = "\t";
    private static final String DETAIL = "detail";
    public static final String COLUMN_RESOURCE_NAMES_0 = "name";
    public static final String COLUMN_RESOURCE_NAMES_1 = "value";
    public static final String COLUMN_RESOURCE_NAMES_2 = "description";

    public ArgumentsPanel() {
        this(JMeterUtils.getResString("user_defined_variables"), null, true, true);
    }

    public ArgumentsPanel(String label) {
        this(label, null, true, false);
    }

    public ArgumentsPanel(String label, boolean enableUpDown) {
        this(label, null, enableUpDown, false);
    }

    public ArgumentsPanel(boolean disableButtons, String label) {
        this(label, null, false, false, null, disableButtons);
    }

    public ArgumentsPanel(String label, Color bkg) {
        this(label, bkg, true, false);
    }

    public ArgumentsPanel(String label, Color bkg, boolean enableUpDown, boolean standalone) {
        this(label, bkg, enableUpDown, standalone, null, false);
    }

    public ArgumentsPanel(String label, Color bkg, boolean enableUpDown, boolean standalone, ObjectTableModel model) {
        this(label, bkg, enableUpDown, standalone, model, false);
    }

    public ArgumentsPanel(String label, Color bkg, boolean enableUpDown, boolean standalone, ObjectTableModel model, boolean disableButtons) {
        this.tableLabel = new JLabel(label);
        this.enableUpDown = enableUpDown;
        this.disableButtons = disableButtons;
        this.background = bkg;
        this.standalone = standalone;
        this.tableModel = model;
        this.init();
    }

    @Override
    public Collection<String> getMenuCategories() {
        if (this.standalone) {
            return super.getMenuCategories();
        }
        return null;
    }

    @Override
    public String getLabelResource() {
        return "user_defined_variables";
    }

    @Override
    public TestElement createTestElement() {
        Arguments args = new Arguments();
        this.modifyTestElement(args);
        return args;
    }

    @Override
    public void modifyTestElement(TestElement args) {
        GuiUtils.stopTableEditing(this.table);
        if (args instanceof Arguments) {
            Arguments arguments = (Arguments)args;
            arguments.clear();
            Iterator<?> modelData = this.tableModel.iterator();
            while (modelData.hasNext()) {
                Argument arg = (Argument)modelData.next();
                if (StringUtils.isEmpty(arg.getName()) && StringUtils.isEmpty(arg.getValue())) continue;
                arg.setMetaData("=");
                arguments.addArgument(arg);
            }
        }
        super.configureTestElement(args);
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        if (el instanceof Arguments) {
            this.tableModel.clearData();
            for (JMeterProperty jMeterProperty : (Arguments)el) {
                Argument arg = (Argument)jMeterProperty.getObjectValue();
                this.tableModel.addRow(arg);
            }
        }
        this.checkButtonsStatus();
    }

    protected JTable getTable() {
        return this.table;
    }

    protected JLabel getTableLabel() {
        return this.tableLabel;
    }

    protected JButton getDeleteButton() {
        return this.delete;
    }

    protected JButton getAddButton() {
        return this.add;
    }

    protected void checkButtonsStatus() {
        if (!this.disableButtons) {
            if (this.tableModel.getRowCount() == 0) {
                this.delete.setEnabled(false);
                this.showDetail.setEnabled(false);
            } else {
                this.delete.setEnabled(true);
                this.showDetail.setEnabled(true);
            }
            if (this.enableUpDown) {
                if (this.tableModel.getRowCount() > 1) {
                    this.up.setEnabled(true);
                    this.down.setEnabled(true);
                } else {
                    this.up.setEnabled(false);
                    this.down.setEnabled(false);
                }
            }
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.clear();
    }

    public void clear() {
        GuiUtils.stopTableEditing(this.table);
        this.tableModel.clearData();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.disableButtons) {
            String action = e.getActionCommand();
            if (action.equals(DELETE)) {
                this.deleteArgument();
            } else if (action.equals(ADD)) {
                this.addArgument();
            } else if (action.equals(ADD_FROM_CLIPBOARD)) {
                this.addFromClipboard();
            } else if (action.equals(UP)) {
                this.moveUp();
            } else if (action.equals(DOWN)) {
                this.moveDown();
            } else if (action.equals(DETAIL)) {
                this.showDetail();
            }
        }
    }

    private void moveDown() {
        int[] rowsSelected = this.table.getSelectedRows();
        GuiUtils.stopTableEditing(this.table);
        if (rowsSelected.length > 0 && rowsSelected[rowsSelected.length - 1] < this.table.getRowCount() - 1) {
            this.table.clearSelection();
            for (int i = rowsSelected.length - 1; i >= 0; --i) {
                int rowSelected = rowsSelected[i];
                this.tableModel.moveRow(rowSelected, rowSelected + 1, rowSelected + 1);
            }
            for (int rowSelected : rowsSelected) {
                this.table.addRowSelectionInterval(rowSelected + 1, rowSelected + 1);
            }
            this.scrollToRowIfNotVisible(rowsSelected[0] + 1);
        }
    }

    private void scrollToRowIfNotVisible(int rowIndex) {
        if (this.table.getParent() instanceof JViewport) {
            Rectangle visibleRect = this.table.getVisibleRect();
            boolean cellIndex = false;
            Rectangle cellRect = this.table.getCellRect(rowIndex, 0, false);
            if (visibleRect.y > cellRect.y) {
                this.table.scrollRectToVisible(cellRect);
            } else {
                Rectangle rect2 = this.table.getCellRect(rowIndex + ArgumentsPanel.getNumberOfVisibleRows(this.table), 0, true);
                int width = rect2.y - cellRect.y;
                this.table.scrollRectToVisible(new Rectangle(cellRect.x, cellRect.y, cellRect.width, cellRect.height + width));
            }
        }
    }

    private static int getNumberOfVisibleRows(JTable table) {
        Rectangle vr = table.getVisibleRect();
        int first = table.rowAtPoint(vr.getLocation());
        vr.translate(0, vr.height);
        return table.rowAtPoint(vr.getLocation()) - first;
    }

    private void moveUp() {
        int[] rowsSelected = this.table.getSelectedRows();
        GuiUtils.stopTableEditing(this.table);
        if (rowsSelected.length > 0 && rowsSelected[0] > 0) {
            this.table.clearSelection();
            for (int rowSelected : rowsSelected) {
                this.tableModel.moveRow(rowSelected, rowSelected + 1, rowSelected - 1);
            }
            for (int rowSelected : rowsSelected) {
                this.table.addRowSelectionInterval(rowSelected - 1, rowSelected - 1);
            }
            this.scrollToRowIfNotVisible(rowsSelected[0] - 1);
        }
    }

    private void showDetail() {
        int[] rowsSelected = this.table.getSelectedRows();
        GuiUtils.stopTableEditing(this.table);
        if (rowsSelected.length == 1) {
            this.table.clearSelection();
            RowDetailDialog detailDialog = new RowDetailDialog(this.tableModel, rowsSelected[0]);
            detailDialog.setVisible(true);
        }
    }

    protected void deleteArgument() {
        GuiUtils.cancelEditing(this.table);
        int[] rowsSelected = this.table.getSelectedRows();
        int anchorSelection = this.table.getSelectionModel().getAnchorSelectionIndex();
        this.table.clearSelection();
        if (rowsSelected.length > 0) {
            for (int i = rowsSelected.length - 1; i >= 0; --i) {
                this.tableModel.removeRow(rowsSelected[i]);
            }
            if (this.tableModel.getRowCount() > 0) {
                if (anchorSelection >= this.tableModel.getRowCount()) {
                    anchorSelection = this.tableModel.getRowCount() - 1;
                }
                this.table.setRowSelectionInterval(anchorSelection, anchorSelection);
            }
            this.checkButtonsStatus();
        }
    }

    protected void addArgument() {
        GuiUtils.stopTableEditing(this.table);
        this.tableModel.addRow(this.makeNewArgument());
        this.checkButtonsStatus();
        int rowToSelect = this.tableModel.getRowCount() - 1;
        this.table.setRowSelectionInterval(rowToSelect, rowToSelect);
        this.table.scrollRectToVisible(this.table.getCellRect(rowToSelect, 0, true));
    }

    protected void addFromClipboard(String lineDelimiter, String argDelimiter) {
        GuiUtils.stopTableEditing(this.table);
        int rowCount = this.table.getRowCount();
        try {
            String[] clipboardLines;
            String clipboardContent = GuiUtils.getPastedText();
            if (clipboardContent == null) {
                return;
            }
            for (String clipboardLine : clipboardLines = clipboardContent.split(lineDelimiter)) {
                String[] clipboardCols = clipboardLine.split(argDelimiter);
                if (clipboardCols.length <= 0) continue;
                Argument argument = this.createArgumentFromClipboard(clipboardCols);
                this.tableModel.addRow(argument);
            }
            if (this.table.getRowCount() > rowCount) {
                this.checkButtonsStatus();
                int rowToSelect = this.tableModel.getRowCount() - 1;
                this.table.setRowSelectionInterval(rowCount, rowToSelect);
                this.table.scrollRectToVisible(this.table.getCellRect(rowCount, 0, true));
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Could not add read arguments from clipboard:\n" + ioe.getLocalizedMessage(), "Error", 0);
        }
        catch (UnsupportedFlavorException ufe) {
            JOptionPane.showMessageDialog(this, "Could not add retrieve " + DataFlavor.stringFlavor.getHumanPresentableName() + " from clipboard" + ufe.getLocalizedMessage(), "Error", 0);
        }
    }

    protected void addFromClipboard() {
        this.addFromClipboard(CLIPBOARD_LINE_DELIMITERS, CLIPBOARD_ARG_DELIMITERS);
    }

    protected Argument createArgumentFromClipboard(String[] clipboardCols) {
        Argument argument = this.makeNewArgument();
        argument.setName(clipboardCols[0]);
        if (clipboardCols.length > 1) {
            argument.setValue(clipboardCols[1]);
            if (clipboardCols.length > 2) {
                argument.setDescription(clipboardCols[2]);
            }
        }
        return argument;
    }

    protected Argument makeNewArgument() {
        return new Argument("", "");
    }

    protected void stopTableEditing() {
        GuiUtils.stopTableEditing(this.table);
    }

    protected void initializeTableModel() {
        if (this.tableModel == null) {
            this.tableModel = this.standalone ? new ObjectTableModel(new String[]{COLUMN_RESOURCE_NAMES_0, COLUMN_RESOURCE_NAMES_1, COLUMN_RESOURCE_NAMES_2}, Argument.class, new Functor[]{new Functor("getName"), new Functor("getValue"), new Functor("getDescription")}, new Functor[]{new Functor("setName"), new Functor("setValue"), new Functor("setDescription")}, new Class[]{String.class, String.class, String.class}) : new ObjectTableModel(new String[]{COLUMN_RESOURCE_NAMES_0, COLUMN_RESOURCE_NAMES_1}, Argument.class, new Functor[]{new Functor("getName"), new Functor("getValue")}, new Functor[]{new Functor("setName"), new Functor("setValue")}, new Class[]{String.class, String.class});
        }
    }

    public static boolean testFunctors() {
        ArgumentsPanel instance = new ArgumentsPanel();
        instance.initializeTableModel();
        return instance.tableModel.checkFunctors(null, instance.getClass());
    }

    protected void sizeColumns(JTable _table) {
    }

    private JComponent makeMainPanel() {
        this.initializeTableModel();
        this.table = new JTable(this.tableModel);
        this.table.getTableHeader().setDefaultRenderer(new HeaderAsPropertyRenderer());
        this.table.setSelectionMode(2);
        if (this.background != null) {
            this.table.setBackground(this.background);
        }
        JMeterUtils.applyHiDPI(this.table);
        return this.makeScrollPane(this.table);
    }

    protected Component makeLabelPanel() {
        JPanel labelPanel = new JPanel(new FlowLayout(1));
        labelPanel.add(this.tableLabel);
        if (this.background != null) {
            labelPanel.setBackground(this.background);
        }
        return labelPanel;
    }

    private JPanel makeButtonPanel() {
        this.showDetail = new JButton(JMeterUtils.getResString(DETAIL));
        this.showDetail.setActionCommand(DETAIL);
        this.showDetail.setEnabled(true);
        this.add = new JButton(JMeterUtils.getResString(ADD));
        this.add.setActionCommand(ADD);
        this.add.setEnabled(true);
        JButton addFromClipboard = new JButton(JMeterUtils.getResString("add_from_clipboard"));
        addFromClipboard.setActionCommand(ADD_FROM_CLIPBOARD);
        addFromClipboard.setEnabled(true);
        this.delete = new JButton(JMeterUtils.getResString(DELETE));
        this.delete.setActionCommand(DELETE);
        if (this.enableUpDown) {
            this.up = new JButton(JMeterUtils.getResString(UP));
            this.up.setActionCommand(UP);
            this.down = new JButton(JMeterUtils.getResString(DOWN));
            this.down.setActionCommand(DOWN);
        }
        this.checkButtonsStatus();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        if (this.background != null) {
            buttonPanel.setBackground(this.background);
        }
        this.showDetail.addActionListener(this);
        this.add.addActionListener(this);
        addFromClipboard.addActionListener(this);
        this.delete.addActionListener(this);
        buttonPanel.add(this.showDetail);
        buttonPanel.add(this.add);
        buttonPanel.add(addFromClipboard);
        buttonPanel.add(this.delete);
        if (this.enableUpDown) {
            this.up.addActionListener(this);
            this.down.addActionListener(this);
            buttonPanel.add(this.up);
            buttonPanel.add(this.down);
        }
        return buttonPanel;
    }

    private void init() {
        JPanel p = this;
        if (this.standalone) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(this.makeBorder());
            this.add((Component)this.makeTitlePanel(), "North");
            p = new JPanel();
        }
        p.setLayout(new BorderLayout());
        p.add(this.makeLabelPanel(), "North");
        this.mainPanel = this.makeMainPanel();
        p.add((Component)this.mainPanel, "Center");
        p.add(Box.createVerticalStrut(70), "West");
        if (!this.disableButtons) {
            p.add((Component)this.makeButtonPanel(), "South");
        }
        if (this.standalone) {
            this.add((Component)p, "Center");
        }
        this.table.revalidate();
        this.sizeColumns(this.table);
    }

    public void clearBorderForMainPanel() {
        GuiUtils.emptyBorder(this.mainPanel);
    }
}

