/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;

public class InterleaveControl
extends GenericController
implements Serializable {
    private static final long serialVersionUID = 234L;
    private static final String STYLE = "InterleaveControl.style";
    private static final String ACCROSS_THREADS = "InterleaveControl.accrossThreads";
    public static final int IGNORE_SUB_CONTROLLERS = 0;
    public static final int USE_SUB_CONTROLLERS = 1;
    private boolean skipNext;
    private transient TestElement searchStart = null;
    private boolean currentReturnedAtLeastOne;
    private boolean stillSame = true;

    @Override
    public void reInitialize() {
        this.setFirst(true);
        this.currentReturnedAtLeastOne = false;
        this.searchStart = null;
        this.stillSame = true;
        this.skipNext = false;
        this.incrementIterCount();
        this.recoverRunningVersion();
    }

    public void setStyle(int style) {
        this.setProperty(new IntegerProperty(STYLE, style));
    }

    public int getStyle() {
        return this.getPropertyAsInt(STYLE);
    }

    public void setInterleaveAccrossThreads(boolean accrossThreads) {
        this.setProperty(new BooleanProperty(ACCROSS_THREADS, accrossThreads));
    }

    public boolean getInterleaveAccrossThreads() {
        return this.getPropertyAsBoolean(ACCROSS_THREADS, false);
    }

    @Override
    public Sampler next() {
        if (this.isSkipNext()) {
            this.reInitialize();
            return null;
        }
        return super.next();
    }

    @Override
    protected Sampler nextIsAController(Controller controller) throws NextIsNullException {
        Sampler sampler = controller.next();
        if (sampler == null) {
            this.currentReturnedNull(controller);
            return this.next();
        }
        this.currentReturnedAtLeastOne = true;
        if (this.getStyle() == 0) {
            this.incrementCurrent();
            this.skipNext = true;
        } else {
            this.searchStart = null;
        }
        return sampler;
    }

    @Override
    protected Sampler nextIsASampler(Sampler element) throws NextIsNullException {
        this.skipNext = true;
        this.incrementCurrent();
        return element;
    }

    @Override
    protected Sampler nextIsNull() {
        this.resetCurrent();
        return this.next();
    }

    @Override
    protected void setCurrentElement(TestElement currentElement) throws NextIsNullException {
        if (this.searchStart == null) {
            this.searchStart = currentElement;
        } else if (this.searchStart == currentElement && !this.stillSame) {
            this.reInitialize();
            throw new NextIsNullException();
        }
    }

    @Override
    protected void currentReturnedNull(Controller c) {
        if (c.isDone()) {
            this.removeCurrentElement();
        } else if (this.getStyle() == 1) {
            this.incrementCurrent();
        }
    }

    protected boolean isSkipNext() {
        return this.skipNext;
    }

    protected void setSkipNext(boolean skipNext) {
        this.skipNext = skipNext;
    }

    @Override
    protected void incrementCurrent() {
        if (this.currentReturnedAtLeastOne) {
            this.skipNext = true;
        }
        this.stillSame = false;
        super.incrementCurrent();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.getInterleaveAccrossThreads()) {
            this.current = this.getThreadContext().getThreadNum() % this.getSubControllers().size();
        }
    }
}

