/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.StringProperty;

public class SwitchController
extends GenericController
implements Serializable {
    private static final long serialVersionUID = 240L;
    static final String SWITCH_VALUE = "SwitchController.value";

    @Override
    public Sampler next() {
        if (this.isFirst()) {
            this.current = this.getSelectionAsInt();
        }
        return super.next();
    }

    @Override
    protected void incrementCurrent() {
        this.current = Integer.MAX_VALUE;
    }

    public void setSelection(String inputValue) {
        this.setProperty(new StringProperty(SWITCH_VALUE, inputValue));
    }

    private int getSelectionAsInt() {
        this.getProperty(SWITCH_VALUE).recoverRunningVersion(null);
        String sel = this.getSelection();
        if (StringUtils.isEmpty(sel)) {
            return 0;
        }
        try {
            if (StringUtils.isNumeric(sel)) {
                int ret = Integer.parseInt(sel);
                if (ret < 0 || ret >= this.getSubControllers().size()) {
                    ret = 0;
                }
                return ret;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.scanControllerNames(sel);
    }

    private int scanControllerNames(String sel) {
        int i = 0;
        int defaultPos = Integer.MAX_VALUE;
        for (TestElement el : this.getSubControllers()) {
            String name = el.getName();
            if (name.equals(sel)) {
                return i;
            }
            if (name.equalsIgnoreCase("default")) {
                defaultPos = i;
            }
            ++i;
        }
        return defaultPos;
    }

    public String getSelection() {
        return this.getPropertyAsString(SWITCH_VALUE).trim();
    }
}

