/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.control.CriticalSectionController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="critical_section_controller_title")
public class CriticalSectionControllerGui
extends AbstractControllerGui {
    private static final long serialVersionUID = 7177285850634344095L;
    private JTextField tfLockName;
    private boolean displayName = true;

    public CriticalSectionControllerGui() {
        this(true);
    }

    public CriticalSectionControllerGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof CriticalSectionController) {
            CriticalSectionController controller = (CriticalSectionController)element;
            this.tfLockName.setText(controller.getLockName());
        }
    }

    @Override
    public TestElement createTestElement() {
        CriticalSectionController controller = new CriticalSectionController();
        this.modifyTestElement(controller);
        return controller;
    }

    @Override
    public void modifyTestElement(TestElement controller) {
        this.configureTestElement(controller);
        if (controller instanceof CriticalSectionController) {
            CriticalSectionController csController = (CriticalSectionController)controller;
            csController.setLockName(this.tfLockName.getText());
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.tfLockName.setText("global_lock");
    }

    @Override
    public String getLabelResource() {
        return "critical_section_controller_title";
    }

    private void init() {
        if (this.displayName) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(this.makeBorder());
            this.add((Component)this.makeTitlePanel(), "North");
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)this.createCriticalSectionPanel(), "North");
            this.add((Component)mainPanel, "Center");
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createCriticalSectionPanel(), "North");
        }
    }

    private JPanel createCriticalSectionPanel() {
        JPanel conditionPanel = new JPanel(new BorderLayout(5, 0));
        JLabel conditionLabel = new JLabel(JMeterUtils.getResString("critical_section_controller_label"));
        conditionPanel.add((Component)conditionLabel, "West");
        this.tfLockName = new JTextField("");
        conditionLabel.setLabelFor(this.tfLockName);
        conditionPanel.add((Component)this.tfLockName, "Center");
        conditionPanel.add(Box.createHorizontalStrut(conditionLabel.getPreferredSize().width + this.tfLockName.getPreferredSize().width), "North");
        return conditionPanel;
    }
}

