/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.control.IfController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JFactory;

@GUIMenuSortOrder(value=1)
@TestElementMetadata(labelResource="if_controller_title")
public class IfControllerPanel
extends AbstractControllerGui
implements ChangeListener,
ActionListener {
    private static final long serialVersionUID = 240L;
    private static final String USE_LAST_SAMPLE_OK = "use_last_sample_ok";
    private JLabel warningLabel;
    private JLabel conditionLabel;
    private JSyntaxTextArea theCondition;
    private JCheckBox useExpression;
    private JCheckBox evaluateAll;
    private boolean displayName = true;
    private JButton useLastSampleStatusButton;

    public IfControllerPanel() {
        this(true);
    }

    public IfControllerPanel(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof IfController) {
            IfController ifController = (IfController)element;
            this.theCondition.setText(ifController.getCondition());
            this.evaluateAll.setSelected(ifController.isEvaluateAll());
            this.useExpression.setSelected(ifController.isUseExpression());
        }
    }

    @Override
    public TestElement createTestElement() {
        IfController controller = new IfController();
        this.modifyTestElement(controller);
        return controller;
    }

    @Override
    public void modifyTestElement(TestElement controller) {
        this.configureTestElement(controller);
        if (controller instanceof IfController) {
            IfController ifController = (IfController)controller;
            ifController.setCondition(this.theCondition.getText());
            ifController.setEvaluateAll(this.evaluateAll.isSelected());
            ifController.setUseExpression(this.useExpression.isSelected());
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.useExpression.setSelected(true);
        this.theCondition.setText("");
        this.evaluateAll.setSelected(false);
    }

    @Override
    public String getLabelResource() {
        return "if_controller_title";
    }

    private void init() {
        if (this.displayName) {
            this.setLayout(new BorderLayout(0, 5));
            this.setBorder(this.makeBorder());
            this.add((Component)this.makeTitlePanel(), "North");
            this.add((Component)this.createConditionPanel(), "Center");
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createConditionPanel(), "North");
        }
    }

    private JPanel createConditionPanel() {
        JPanel conditionPanel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2, insets 0", "[][fill,grow]"));
        ImageIcon image = JMeterUtils.getImage("warning.png");
        this.warningLabel = new JLabel(JMeterUtils.getResString("if_controller_warning"), image, 2);
        JFactory.warning(this.warningLabel);
        conditionPanel.add((Component)this.warningLabel, "span 2");
        this.conditionLabel = new JLabel(JMeterUtils.getResString("if_controller_label"));
        conditionPanel.add(this.conditionLabel);
        this.conditionLabel.setName("if_controller_label");
        this.theCondition = JSyntaxTextArea.getInstance(5, 50);
        this.conditionLabel.setLabelFor((Component)((Object)this.theCondition));
        conditionPanel.add((Component)((Object)JTextScrollPane.getInstance(this.theCondition)));
        JLabel ifControllerTipLabel = new JLabel(JMeterUtils.getResString("if_controller_tip"));
        this.useLastSampleStatusButton = new JButton(JMeterUtils.getResString("if_controller_use_last_sample_ok"));
        this.useLastSampleStatusButton.setActionCommand(USE_LAST_SAMPLE_OK);
        this.useLastSampleStatusButton.addActionListener(this);
        conditionPanel.add(this.useLastSampleStatusButton);
        conditionPanel.add(ifControllerTipLabel);
        this.useExpression = new JCheckBox(JMeterUtils.getResString("if_controller_expression"));
        this.useExpression.addChangeListener(this);
        conditionPanel.add((Component)this.useExpression, "span 2");
        this.evaluateAll = new JCheckBox(JMeterUtils.getResString("if_controller_evaluate_all"));
        conditionPanel.add((Component)this.evaluateAll, "span 2");
        return conditionPanel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.useExpression) {
            String colorId;
            if (this.useExpression.isSelected()) {
                colorId = "[jmeter]Label.warningForeground";
                this.conditionLabel.setText(JMeterUtils.getResString("if_controller_expression_label"));
                this.useLastSampleStatusButton.setEnabled(true);
            } else {
                colorId = "[jmeter]Label.errorForeground";
                this.conditionLabel.setText(JMeterUtils.getResString("if_controller_label"));
                this.useLastSampleStatusButton.setEnabled(false);
            }
            this.warningLabel.setForeground(UIManager.getColor(colorId));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(USE_LAST_SAMPLE_OK)) {
            this.theCondition.setText(this.theCondition.getText() + "${JMeterThread.last_sample_ok}");
        }
    }
}

