/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import javax.swing.JPopupMenu;
import org.apache.jmeter.control.IncludeController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

@TestElementMetadata(labelResource="include_controller")
public class IncludeControllerGui
extends AbstractControllerGui {
    private static final long serialVersionUID = 240L;
    private final FilePanel includePanel = new FilePanel(JMeterUtils.getResString("include_path"), ".jmx");

    public IncludeControllerGui() {
        this.init();
    }

    @Override
    public String getLabelResource() {
        return "include_controller";
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        IncludeController controller = (IncludeController)el;
        this.includePanel.setFilename(controller.getIncludePath());
    }

    @Override
    public TestElement createTestElement() {
        IncludeController mc = new IncludeController();
        this.configureTestElement(mc);
        return mc;
    }

    @Override
    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        IncludeController controller = (IncludeController)element;
        controller.setIncludePath(this.includePanel.getFilename());
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.includePanel.clearGui();
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        MenuFactory.addEditMenu(menu, true);
        MenuFactory.addFileMenu(menu);
        return menu;
    }

    private void init() {
        this.setLayout(new VerticalLayout(5, 3, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        this.add(this.includePanel);
    }
}

