/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import javax.swing.JCheckBox;
import org.apache.jmeter.control.InterleaveControl;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.CheckBoxPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

@TestElementMetadata(labelResource="interleave_control_title")
public class InterleaveControlGui
extends AbstractControllerGui {
    private static final long serialVersionUID = 240L;
    private JCheckBox style;
    private JCheckBox accrossThreads;

    public InterleaveControlGui() {
        this.init();
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        InterleaveControl controller = (InterleaveControl)el;
        if (controller.getStyle() == 0) {
            this.style.setSelected(true);
        } else {
            this.style.setSelected(false);
        }
        this.accrossThreads.setSelected(controller.getInterleaveAccrossThreads());
    }

    @Override
    public TestElement createTestElement() {
        InterleaveControl ic = new InterleaveControl();
        this.modifyTestElement(ic);
        return ic;
    }

    @Override
    public void modifyTestElement(TestElement ic) {
        this.configureTestElement(ic);
        InterleaveControl controller = (InterleaveControl)ic;
        if (this.style.isSelected()) {
            controller.setStyle(0);
        } else {
            controller.setStyle(1);
        }
        controller.setInterleaveAccrossThreads(this.accrossThreads.isSelected());
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.style.setSelected(false);
        this.accrossThreads.setSelected(false);
    }

    @Override
    public String getLabelResource() {
        return "interleave_control_title";
    }

    private void init() {
        this.setLayout(new VerticalLayout(5, 3, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        this.style = new JCheckBox(JMeterUtils.getResString("ignore_subcontrollers"));
        this.add(CheckBoxPanel.wrap(this.style));
        this.accrossThreads = new JCheckBox(JMeterUtils.getResString("interleave_accross_threads"));
        this.add(CheckBoxPanel.wrap(this.accrossThreads));
    }
}

