/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import javax.swing.JCheckBox;
import org.apache.jmeter.control.RandomController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.CheckBoxPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

@TestElementMetadata(labelResource="random_control_title")
public class RandomControlGui
extends AbstractControllerGui {
    private static final long serialVersionUID = 240L;
    private JCheckBox style;

    public RandomControlGui() {
        this.init();
    }

    @Override
    public TestElement createTestElement() {
        RandomController ic = new RandomController();
        this.modifyTestElement(ic);
        return ic;
    }

    @Override
    public void modifyTestElement(TestElement ic) {
        this.configureTestElement(ic);
        if (this.style.isSelected()) {
            ((RandomController)ic).setStyle(0);
        } else {
            ((RandomController)ic).setStyle(1);
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.style.setSelected(false);
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        if (((RandomController)el).getStyle() == 0) {
            this.style.setSelected(true);
        } else {
            this.style.setSelected(false);
        }
    }

    @Override
    public String getLabelResource() {
        return "random_control_title";
    }

    private void init() {
        this.setLayout(new VerticalLayout(5, 3, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        this.style = new JCheckBox(JMeterUtils.getResString("ignore_subcontrollers"));
        this.add(CheckBoxPanel.wrap(this.style));
    }
}

