/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine.util;

import java.util.Map;
import org.apache.jmeter.engine.util.AbstractTransformer;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.StringUtilities;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceFunctionsWithStrings
extends AbstractTransformer {
    private static final Logger log = LoggerFactory.getLogger(ReplaceFunctionsWithStrings.class);
    private static final String FUNCTION_REF_PREFIX = "${";
    private static final String FUNCTION_REF_SUFFIX = "}";
    private final boolean regexMatch;

    public ReplaceFunctionsWithStrings(CompoundVariable masterFunction, Map<String, String> variables) {
        this(masterFunction, variables, false);
    }

    public ReplaceFunctionsWithStrings(CompoundVariable masterFunction, Map<String, String> variables, boolean regexMatch) {
        this.setMasterFunction(masterFunction);
        this.setVariables((Map)variables);
        this.regexMatch = regexMatch;
    }

    @Override
    public JMeterProperty transformValue(JMeterProperty prop) throws InvalidVariableException {
        Perl5Matcher pm = JMeterUtils.getMatcher();
        Perl5Compiler compiler = new Perl5Compiler();
        String input = prop.getStringValue();
        if (input == null) {
            return prop;
        }
        for (Map.Entry entry : this.getVariables().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (this.regexMatch) {
                try {
                    Pattern pattern = compiler.compile(this.constructPattern(value));
                    input = Util.substitute(pm, pattern, new StringSubstitution(FUNCTION_REF_PREFIX + key + FUNCTION_REF_SUFFIX), input, -1);
                }
                catch (MalformedPatternException e) {
                    log.warn("Malformed pattern: {}", (Object)value);
                }
                continue;
            }
            input = StringUtilities.substitute(input, value, FUNCTION_REF_PREFIX + key + FUNCTION_REF_SUFFIX);
        }
        return new StringProperty(prop.getName(), input);
    }

    private String constructPattern(String value) {
        if (value.startsWith("(") && value.endsWith(")")) {
            return value;
        }
        return "\\b(" + value + ")\\b";
    }
}

