/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import net.sf.saxon.s9api.SaxonApiException;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.XPathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPath2Extractor
extends AbstractScopedTestElement
implements PostProcessor,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(XPath2Extractor.class);
    private static final long serialVersionUID = 242L;
    private static final int DEFAULT_VALUE = 0;
    public static final String DEFAULT_VALUE_AS_STRING = Integer.toString(0);
    private static final String REF_MATCH_NR = "matchNr";
    private static final String XPATH_QUERY = "XPathExtractor2.xpathQuery";
    private static final String REFNAME = "XPathExtractor2.refname";
    private static final String DEFAULT = "XPathExtractor2.default";
    private static final String FRAGMENT = "XPathExtractor2.fragment";
    private static final String NAMESPACES = "XPathExtractor2.namespaces";
    private static final String MATCH_NUMBER = "XPathExtractor2.matchNumber";

    private String concat(String s1, String s2) {
        return s1 + "_" + s2;
    }

    private String concat(String s1, int i) {
        return s1 + "_" + i;
    }

    @Override
    public void process() {
        JMeterContext context = this.getThreadContext();
        SampleResult previousResult = context.getPreviousResult();
        if (previousResult == null) {
            return;
        }
        JMeterVariables vars = context.getVariables();
        String refName = this.getRefName();
        vars.put(refName, this.getDefaultValue());
        String matchNR = this.concat(refName, REF_MATCH_NR);
        int prevCount = 0;
        try {
            prevCount = Integer.parseInt(vars.get(matchNR));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        vars.put(matchNR, "0");
        vars.remove(this.concat(refName, "1"));
        int matchNumber = this.getMatchNumber();
        ArrayList<String> matches = new ArrayList<String>();
        try {
            int i;
            block14: {
                block12: {
                    block13: {
                        if (!this.isScopeVariable()) break block12;
                        String inputString = vars.get(this.getVariableName());
                        if (inputString == null) break block13;
                        if (inputString.length() > 0) {
                            this.getValuesForXPath(this.getXPathQuery(), matches, matchNumber, inputString);
                        }
                        break block14;
                    }
                    if (!log.isWarnEnabled()) break block14;
                    log.warn("No variable '{}' found to process by XPathExtractor '{}', skipping processing", (Object)this.getVariableName(), (Object)this.getName());
                    break block14;
                }
                List<SampleResult> samples = this.getSampleList(previousResult);
                int size = samples.size();
                for (i = 0; i < size; ++i) {
                    this.getValuesForXPath(this.getXPathQuery(), matches, matchNumber, previousResult.getResponseDataAsString());
                }
            }
            int matchCount = matches.size();
            vars.put(matchNR, String.valueOf(matchCount));
            if (matchCount > 0) {
                String value = (String)matches.get(0);
                if (value != null) {
                    vars.put(refName, value);
                }
                for (i = 0; i < matchCount; ++i) {
                    value = (String)matches.get(i);
                    if (value == null) continue;
                    vars.put(this.concat(refName, i + 1), (String)matches.get(i));
                }
            }
            vars.remove(this.concat(refName, matchCount + 1));
            for (int i2 = matchCount + 2; i2 <= prevCount; ++i2) {
                vars.remove(this.concat(refName, i2));
            }
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn("Exception while processing '{}', message:{}", (Object)this.getXPathQuery(), (Object)e.getMessage());
            }
            this.addAssertionFailure(previousResult, e, false);
        }
    }

    private void addAssertionFailure(SampleResult previousResult, Throwable thrown, boolean setFailed) {
        AssertionResult ass = new AssertionResult(this.getName());
        ass.setFailure(true);
        ass.setFailureMessage(thrown.getLocalizedMessage() + "\nSee log file for further details.");
        previousResult.addAssertionResult(ass);
        if (setFailed) {
            previousResult.setSuccessful(false);
        }
    }

    public void setXPathQuery(String val) {
        this.setProperty(XPATH_QUERY, val);
    }

    public String getXPathQuery() {
        return this.getPropertyAsString(XPATH_QUERY);
    }

    public void setRefName(String refName) {
        this.setProperty(REFNAME, refName);
    }

    public String getRefName() {
        return this.getPropertyAsString(REFNAME);
    }

    public void setDefaultValue(String val) {
        this.setProperty(DEFAULT, val);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString(DEFAULT);
    }

    public boolean getFragment() {
        return this.getPropertyAsBoolean(FRAGMENT, false);
    }

    public void setFragment(boolean selected) {
        this.setProperty(FRAGMENT, selected, false);
    }

    private void getValuesForXPath(String query, List<String> matchStrings, int matchNumber, String responseData) throws SaxonApiException, FactoryConfigurationError {
        XPathUtil.putValuesForXPathInListUsingSaxon(responseData, query, matchStrings, this.getFragment(), matchNumber, this.getNamespaces());
    }

    public void setMatchNumber(int matchNumber) {
        this.setProperty(new IntegerProperty(MATCH_NUMBER, matchNumber));
    }

    public void setMatchNumber(String matchNumber) {
        this.setProperty(MATCH_NUMBER, matchNumber);
    }

    public int getMatchNumber() {
        return this.getPropertyAsInt(MATCH_NUMBER, 0);
    }

    public String getMatchNumberAsString() {
        return this.getPropertyAsString(MATCH_NUMBER, DEFAULT_VALUE_AS_STRING);
    }

    public void setNamespaces(String namespaces) {
        this.setProperty(NAMESPACES, namespaces);
    }

    public String getNamespaces() {
        return this.getPropertyAsString(NAMESPACES);
    }
}

