/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.extractor.XPath2Extractor;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="xpath2_extractor_title")
public class XPath2ExtractorGui
extends AbstractPostProcessorGui {
    private static final long serialVersionUID = 1L;
    private final JTextField defaultField = new JTextField(25);
    private final JTextField xpathQueryField = new JTextField(30);
    private final JTextField matchNumberField = new JTextField();
    private final JTextField refNameField = new JTextField(25);
    private JCheckBox getFragment;
    private JSyntaxTextArea namespacesTA;

    @Override
    public String getLabelResource() {
        return "xpath2_extractor_title";
    }

    public XPath2ExtractorGui() {
        this.init();
    }

    @Override
    public void configure(TestElement el) {
        super.configure(el);
        XPath2Extractor xpe = (XPath2Extractor)el;
        this.showScopeSettings(xpe, true);
        this.xpathQueryField.setText(xpe.getXPathQuery());
        this.defaultField.setText(xpe.getDefaultValue());
        this.refNameField.setText(xpe.getRefName());
        this.matchNumberField.setText(xpe.getMatchNumberAsString());
        this.namespacesTA.setText(xpe.getNamespaces());
        this.getFragment.setSelected(xpe.getFragment());
    }

    @Override
    public TestElement createTestElement() {
        XPath2Extractor extractor = new XPath2Extractor();
        this.modifyTestElement(extractor);
        return extractor;
    }

    @Override
    public void modifyTestElement(TestElement extractor) {
        super.configureTestElement(extractor);
        if (extractor instanceof XPath2Extractor) {
            XPath2Extractor xpath = (XPath2Extractor)extractor;
            this.saveScopeSettings(xpath);
            xpath.setDefaultValue(this.defaultField.getText());
            xpath.setRefName(this.refNameField.getText());
            xpath.setMatchNumber(this.matchNumberField.getText());
            xpath.setXPathQuery(this.xpathQueryField.getText());
            xpath.setFragment(this.getFragment.isSelected());
            xpath.setNamespaces(this.namespacesTA.getText());
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.xpathQueryField.setText("");
        this.defaultField.setText("");
        this.refNameField.setText("");
        this.matchNumberField.setText(XPath2Extractor.DEFAULT_VALUE_AS_STRING);
        this.namespacesTA.setText("");
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add((Component)this.makeTitlePanel(), "North");
        this.add((Component)this.makeParameterPanel(), "Center");
    }

    private JPanel makeParameterPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.createScopePanel(true, true, true), "North");
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2, insets 0", "[][fill,grow]"));
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("xpath2_extractor_properties")));
        panel.add(JMeterUtils.labelFor(this.refNameField, "ref_name_field"));
        panel.add(this.refNameField);
        panel.add(JMeterUtils.labelFor(this.xpathQueryField, "xpath_extractor_query"));
        panel.add(this.xpathQueryField);
        panel.add(JMeterUtils.labelFor(this.matchNumberField, "match_num_field"));
        panel.add(this.matchNumberField);
        panel.add(JMeterUtils.labelFor(this.defaultField, "default_value_field"));
        panel.add(this.defaultField);
        this.namespacesTA = JSyntaxTextArea.getInstance(5, 80);
        JTextScrollPane namespaceJSP = JTextScrollPane.getInstance(this.namespacesTA, true);
        panel.add(JMeterUtils.labelFor((Component)((Object)namespaceJSP), "xpath_extractor_user_namespaces"));
        panel.add((Component)((Object)namespaceJSP));
        this.getFragment = new JCheckBox(JMeterUtils.getResString("xpath_extractor_fragment"));
        panel.add((Component)this.getFragment, "span 2");
        mainPanel.add((Component)panel, "Center");
        return mainPanel;
    }
}

